/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class LabelSSTRecord
extends StandardRecord
implements CellValueRecordInterface {
    public static final short sid = 253;
    private int field_1_row;
    private int field_2_column;
    private int field_3_xf_index;
    private int field_4_sst_index;

    public LabelSSTRecord() {
    }

    public LabelSSTRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_column = in.readUShort();
        this.field_3_xf_index = in.readUShort();
        this.field_4_sst_index = in.readInt();
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short col) {
        this.field_2_column = col;
    }

    public void setXFIndex(short index) {
        this.field_3_xf_index = index;
    }

    public void setSSTIndex(int index) {
        this.field_4_sst_index = index;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return (short)this.field_2_column;
    }

    public short getXFIndex() {
        return (short)this.field_3_xf_index;
    }

    public int getSSTIndex() {
        return this.field_4_sst_index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[LABELSST]\n");
        sb.append("    .row     = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("    .column  = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("    .xfindex = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("    .sstindex= ").append(HexDump.intToHex(this.getSSTIndex())).append("\n");
        sb.append("[/LABELSST]\n");
        return sb.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getRow());
        out.writeShort(this.getColumn());
        out.writeShort(this.getXFIndex());
        out.writeInt(this.getSSTIndex());
    }

    protected int getDataSize() {
        return 10;
    }

    public short getSid() {
        return 253;
    }

    public Object clone() {
        LabelSSTRecord rec = new LabelSSTRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_sst_index = this.field_4_sst_index;
        return rec;
    }
}

