/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class MulBlankRecord
extends StandardRecord {
    public static final short sid = 190;
    private int field_1_row;
    private short field_2_first_col;
    private short[] field_3_xfs;
    private short field_4_last_col;

    public MulBlankRecord(int row, int firstCol, short[] xfs) {
        this.field_1_row = row;
        this.field_2_first_col = (short)firstCol;
        this.field_3_xfs = xfs;
        this.field_4_last_col = (short)(firstCol + xfs.length - 1);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int coffset) {
        return this.field_3_xfs[coffset];
    }

    public MulBlankRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_xfs = MulBlankRecord.parseXFs(in);
        this.field_4_last_col = in.readShort();
    }

    private static short[] parseXFs(RecordInputStream in) {
        short[] retval = new short[(in.remaining() - 2) / 2];
        for (int idx = 0; idx < retval.length; ++idx) {
            retval[idx] = in.readShort();
        }
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MULBLANK]\n");
        buffer.append("row  = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        for (int k = 0; k < this.getNumColumns(); ++k) {
            buffer.append("xf").append(k).append("        = ").append(Integer.toHexString(this.getXFAt(k))).append("\n");
        }
        buffer.append("[/MULBLANK]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 190;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_row);
        out.writeShort(this.field_2_first_col);
        int nItems = this.field_3_xfs.length;
        for (int i = 0; i < nItems; ++i) {
            out.writeShort(this.field_3_xfs[i]);
        }
        out.writeShort(this.field_4_last_col);
    }

    protected int getDataSize() {
        return 6 + this.field_3_xfs.length * 2;
    }
}

