/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.pivottable;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class ViewFieldsRecord
extends StandardRecord {
    public static final short sid = 177;
    private static final int STRING_NOT_PRESENT_LEN = -1;
    private int sxaxis;
    private int cSub;
    private int grbitSub;
    private int cItm;
    private String name = null;

    public ViewFieldsRecord(RecordInputStream in) {
        this.sxaxis = in.readShort();
        this.cSub = in.readShort();
        this.grbitSub = in.readShort();
        this.cItm = in.readShort();
        short cchName = in.readShort();
        if (cchName != -1) {
            this.name = in.readCompressedUnicode(cchName);
        }
    }

    protected void serialize(LittleEndianOutput out) {
        out.writeShort(this.sxaxis);
        out.writeShort(this.cSub);
        out.writeShort(this.grbitSub);
        out.writeShort(this.cItm);
        if (this.name != null) {
            StringUtil.writeUnicodeString(out, this.name);
        } else {
            out.writeShort(-1);
        }
    }

    protected int getDataSize() {
        int cchName = 0;
        if (this.name != null) {
            cchName = this.name.length();
        }
        return 10 + cchName;
    }

    public short getSid() {
        return 177;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SXVD]\n");
        buffer.append("    .sxaxis    = ").append(HexDump.shortToHex(this.sxaxis)).append('\n');
        buffer.append("    .cSub      = ").append(HexDump.shortToHex(this.cSub)).append('\n');
        buffer.append("    .grbitSub  = ").append(HexDump.shortToHex(this.grbitSub)).append('\n');
        buffer.append("    .cItm      = ").append(HexDump.shortToHex(this.cItm)).append('\n');
        buffer.append("    .name      = ").append(this.name).append('\n');
        buffer.append("[/SXVD]\n");
        return buffer.toString();
    }

    private static final class Axis {
        public static final int NO_AXIS = 0;
        public static final int ROW = 1;
        public static final int COLUMN = 2;
        public static final int PAGE = 4;
        public static final int DATA = 8;

        private Axis() {
        }
    }
}

