/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.util.IntList;
import org.apache.poi.util.LittleEndian;

public class BlockAllocationTableReader {
    private IntList _entries = new IntList();

    public BlockAllocationTableReader(int block_count, int[] block_array, int xbat_count, int xbat_index, BlockList raw_block_list) throws IOException {
        this();
        int block_index;
        if (block_count <= 0) {
            throw new IOException("Illegal block count; minimum count is 1, got " + block_count + " instead");
        }
        ListManagedBlock[] blocks = new RawDataBlock[block_count];
        int limit = Math.min(block_count, block_array.length);
        for (block_index = 0; block_index < limit; ++block_index) {
            blocks[block_index] = (RawDataBlock)raw_block_list.remove(block_array[block_index]);
        }
        if (block_index < block_count) {
            if (xbat_index < 0) {
                throw new IOException("BAT count exceeds limit, yet XBAT index indicates no valid entries");
            }
            int chain_index = xbat_index;
            int max_entries_per_block = BATBlock.entriesPerXBATBlock();
            int chain_index_offset = BATBlock.getXBATChainOffset();
            for (int j = 0; j < xbat_count; ++j) {
                limit = Math.min(block_count - block_index, max_entries_per_block);
                byte[] data = raw_block_list.remove(chain_index).getData();
                int offset = 0;
                for (int k = 0; k < limit; ++k) {
                    blocks[block_index++] = (RawDataBlock)raw_block_list.remove(LittleEndian.getInt(data, offset));
                    offset += 4;
                }
                chain_index = LittleEndian.getInt(data, chain_index_offset);
                if (chain_index == -2) break;
            }
        }
        if (block_index != block_count) {
            throw new IOException("Could not find all blocks");
        }
        this.setEntries(blocks, raw_block_list);
    }

    BlockAllocationTableReader(ListManagedBlock[] blocks, BlockList raw_block_list) throws IOException {
        this();
        this.setEntries(blocks, raw_block_list);
    }

    BlockAllocationTableReader() {
    }

    ListManagedBlock[] fetchBlocks(int startBlock, int headerPropertiesStartBlock, BlockList blockList) throws IOException {
        ArrayList<ListManagedBlock> blocks = new ArrayList<ListManagedBlock>();
        int currentBlock = startBlock;
        boolean firstPass = true;
        while (currentBlock != -2) {
            try {
                blocks.add(blockList.remove(currentBlock));
                currentBlock = this._entries.get(currentBlock);
            }
            catch (IOException e) {
                if (currentBlock == headerPropertiesStartBlock) {
                    System.err.println("Warning, header block comes after data blocks in POIFS block listing");
                    currentBlock = -2;
                    continue;
                }
                throw e;
            }
        }
        return blocks.toArray(new ListManagedBlock[0]);
    }

    boolean isUsed(int index) {
        boolean rval = false;
        try {
            rval = this._entries.get(index) != -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return rval;
    }

    int getNextBlockIndex(int index) throws IOException {
        if (this.isUsed(index)) {
            return this._entries.get(index);
        }
        throw new IOException("index " + index + " is unused");
    }

    private void setEntries(ListManagedBlock[] blocks, BlockList raw_blocks) throws IOException {
        int limit = BATBlock.entriesPerBlock();
        for (int block_index = 0; block_index < blocks.length; ++block_index) {
            byte[] data = blocks[block_index].getData();
            int offset = 0;
            for (int k = 0; k < limit; ++k) {
                int entry = LittleEndian.getInt(data, offset);
                if (entry == -1) {
                    raw_blocks.zap(this._entries.size());
                }
                this._entries.add(entry);
                offset += 4;
            }
            blocks[block_index] = null;
        }
        raw_blocks.setBAT(this);
    }
}

