/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.Iterator;
import java.util.List;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlMergeInfo
implements ISVNMergeInfo {
    Mergeinfo info;

    public JhlMergeInfo() {
        this.info = new Mergeinfo();
    }

    public JhlMergeInfo(Mergeinfo info) {
        this.info = info;
    }

    public void addRevisionRange(String path, SVNRevisionRange range) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.addRevisionRange(path, JhlConverter.convert(range));
    }

    public void addRevisions(String path, SVNRevisionRange[] range) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.addRevisions(path, JhlConverter.convert(range));
    }

    public String[] getPaths() {
        if (this.info == null) {
            return null;
        }
        return this.info.getPaths();
    }

    public SVNRevisionRange[] getRevisionRange(String path) {
        if (this.info == null) {
            return null;
        }
        return JhlConverter.convert(this.info.getRevisionRange(path));
    }

    public SVNRevisionRange[] getRevisions(String path) {
        if (this.info == null) {
            return null;
        }
        List rangeList = this.info.getRevisions(path);
        SVNRevisionRange[] range = new SVNRevisionRange[rangeList.size()];
        int i = 0;
        Iterator iter = rangeList.iterator();
        while (iter.hasNext()) {
            range[i] = JhlConverter.convert((RevisionRange)iter.next());
        }
        return range;
    }

    public void loadFromMergeInfoProperty(String mergeInfo) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.loadFromMergeinfoProperty(mergeInfo);
    }
}

