/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceDeePathBackwardExtender;
import de.regnis.q.sequence.core.QSequenceDeePathExtender;
import de.regnis.q.sequence.core.QSequenceDeePathForwardExtender;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceMiddleSnakeFinderResult;

class QSequenceMiddleSnakeFinder {
    private final QSequenceDeePathForwardExtender forwardDeePathExtender;
    private final QSequenceDeePathBackwardExtender backwardDeePathExtender;
    private final QSequenceMiddleSnakeFinderResult result;
    private final int maximumSearchDepth;

    public QSequenceMiddleSnakeFinder(int maximumMediaLeftLength, int maximumMediaRightLength, int maximumSearchDepth) {
        this.maximumSearchDepth = maximumSearchDepth;
        this.forwardDeePathExtender = new QSequenceDeePathForwardExtender(maximumMediaLeftLength, maximumMediaRightLength);
        this.backwardDeePathExtender = new QSequenceDeePathBackwardExtender(maximumMediaLeftLength, maximumMediaRightLength);
        this.result = new QSequenceMiddleSnakeFinderResult();
    }

    public QSequenceMiddleSnakeFinderResult getResult() {
        return this.result;
    }

    public int determineMiddleSnake(QSequenceMedia media) throws QSequenceException {
        this.result.reset();
        this.forwardDeePathExtender.reset(media);
        this.backwardDeePathExtender.reset(media);
        int delta = media.getLeftLength() - media.getRightLength();
        int deeMax = (int)Math.ceil(((double)media.getLeftLength() + (double)media.getRightLength()) / 2.0);
        for (int dee = 0; dee <= deeMax; ++dee) {
            int diagonal;
            int n = diagonal = delta >= 0 ? dee : -dee;
            while (delta >= 0 ? diagonal >= -dee : diagonal <= dee) {
                this.forwardDeePathExtender.extendDeePath(media, dee, diagonal);
                if (QSequenceMiddleSnakeFinder.checkForwardOverlapping(delta, diagonal, dee) && this.isForwardAndBackwardOverlapping(diagonal)) {
                    QSequenceMiddleSnakeFinder.setMiddleSnake(this.result, this.forwardDeePathExtender, diagonal);
                    return 2 * dee - 1;
                }
                diagonal += delta >= 0 ? -2 : 2;
            }
            int n2 = diagonal = delta >= 0 ? -dee : dee;
            while (delta >= 0 ? diagonal <= dee : diagonal >= -dee) {
                int deltadDiagonal = diagonal + delta;
                this.backwardDeePathExtender.extendDeePath(media, dee, deltadDiagonal);
                if (QSequenceMiddleSnakeFinder.checkBackwardOverlapping(delta, diagonal, dee) && this.isForwardAndBackwardOverlapping(deltadDiagonal)) {
                    QSequenceMiddleSnakeFinder.setMiddleSnake(this.result, this.backwardDeePathExtender, deltadDiagonal);
                    return 2 * dee;
                }
                diagonal += delta >= 0 ? 2 : -2;
            }
            if (dee < this.maximumSearchDepth) continue;
            return this.determineBestSnake(media, dee, delta);
        }
        QSequenceAssert.assertTrue(false);
        return 0;
    }

    private boolean isForwardAndBackwardOverlapping(int diagonal) {
        int backwardLeft;
        int forwardLeft = this.forwardDeePathExtender.getLeft(diagonal);
        return forwardLeft >= (backwardLeft = this.backwardDeePathExtender.getLeft(diagonal));
    }

    private int determineBestSnake(QSequenceMedia media, int dee, int delta) {
        int bestForwardDiagonal = this.getBestForwardDiagonal(dee, delta);
        int bestBackwardDiagonal = this.getBestBackwardDiagonal(dee, delta);
        if (this.forwardDeePathExtender.getProgress(bestForwardDiagonal) > this.backwardDeePathExtender.getProgress(bestBackwardDiagonal)) {
            int left = this.forwardDeePathExtender.getLeft(bestForwardDiagonal);
            int right = this.forwardDeePathExtender.getRight(bestForwardDiagonal);
            this.result.setMiddleSnake(left, right, left, right);
            return 2 * dee - 1;
        }
        int left = this.backwardDeePathExtender.getLeft(bestBackwardDiagonal);
        int right = this.backwardDeePathExtender.getRight(bestBackwardDiagonal);
        if (left < 0 || right < 0) {
            this.backwardDeePathExtender.print(media, -dee + delta, dee + delta);
        }
        this.result.setMiddleSnake(left, right, left, right);
        return 2 * dee;
    }

    private int getBestForwardDiagonal(int dee, int delta) {
        int diagonal;
        int bestDiagonal = 0;
        int bestProgress = 0;
        int n = diagonal = delta >= 0 ? dee : -dee;
        while (delta >= 0 ? diagonal >= -dee : diagonal <= dee) {
            int progress = this.forwardDeePathExtender.getProgress(diagonal);
            if (progress > bestProgress) {
                bestDiagonal = diagonal;
                bestProgress = progress;
            }
            diagonal += delta >= 0 ? -2 : 2;
        }
        return bestDiagonal;
    }

    private int getBestBackwardDiagonal(int dee, int delta) {
        int diagonal;
        int bestDiagonal = delta;
        int bestProgress = 0;
        int n = diagonal = delta >= 0 ? -dee : dee;
        while (delta >= 0 ? diagonal <= dee : diagonal >= -dee) {
            int deltadDiagonal = diagonal + delta;
            int progress = this.backwardDeePathExtender.getProgress(deltadDiagonal);
            if (progress > bestProgress) {
                bestDiagonal = deltadDiagonal;
                bestProgress = progress;
            }
            diagonal += delta >= 0 ? 2 : -2;
        }
        return bestDiagonal;
    }

    public static void setMiddleSnake(QSequenceMiddleSnakeFinderResult result, QSequenceDeePathExtender extender, int diagonal) {
        result.setMiddleSnake(Math.min(extender.getLeft(diagonal), extender.getSnakeStartLeft()), Math.min(extender.getRight(diagonal), extender.getSnakeStartRight()), Math.max(extender.getLeft(diagonal), extender.getSnakeStartLeft()), Math.max(extender.getRight(diagonal), extender.getSnakeStartRight()));
    }

    private static boolean checkForwardOverlapping(int delta, int diagonal, int dee) {
        return diagonal >= delta - (dee - 1) && diagonal <= delta + (dee - 1);
    }

    private static boolean checkBackwardOverlapping(int delta, int diagonal, int dee) {
        return diagonal + delta >= -dee && diagonal + delta <= dee;
    }
}

