/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: SheetParser.java 56 2009-05-21 04:13:39Z yuta-takahashi $
 * $Revision: 56 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * V[g̉͂sNX
 * 
 * ^OāAv^O݂ꍇ͑Ή^Op[TĂяoA
 * ʂSheetDataɐݒ肷
 * 
 * ^Ǒ͍s([1,A] [1,B]EEEA[2,A] [2,B]EEE)ōs
 * 
 * ^OLastTag=Truẽp[^ݒ肳Ăꍇ͂̃^OďIB
 * 
 * @since 1.0
 */
public class SheetParser {
	
	/** ʃL[p[^ */
    protected static final String PARAM_RESULT_KEY = "ResultKey";

    /** ŏI^Op[^ */
    protected static final String PARAM_LAST_TAG = "LastTag";

    /** O */
    private static Log log = LogFactory.getLog( SheetParser.class);

    /** ^Op[T̃Xg */
    private List<TagParser<?>> tagParsers = new ArrayList<TagParser<?>>();

    /**
     * V[g̉
     * 
     * @param sheet ͑ΏۃV[g
     * @param object BookControllerparseBook(), parseSheet()\bhA 
     *                SheetParserparseSheet\bhňnꍇ
     *                TagParser܂ňp鏈f[^
     * @return ͌
     * @throws ParseException ͂ɎsꍇThrow
     */
    public SheetData parseSheet( Sheet sheet, Object data) throws ParseException {
        // ͌
        String sheetName = PoiUtil.getSheetName( sheet);
        SheetData sheetData = new SheetData( sheetName);

        int firstRowNum = sheet.getFirstRowNum();

        // ^OŽ
        for ( int rowCnt = firstRowNum; rowCnt <= sheet.getLastRowNum(); rowCnt++) {
            // s̎擾
            Row row = sheet.getRow( rowCnt);
            if ( row == null) {
                continue;
            }
            if ( row != null) {
                for ( int columnIdx = 0; columnIdx < row.getLastCellNum(); columnIdx++) {
                    // Z̎擾
                    Cell cell = row.getCell( columnIdx);
                    if ( cell == null) {
                        continue;
                    }
                    for ( TagParser<?> parser : tagParsers) {
                        // `FbN
                        if ( parser.isParse( sheet, cell)) {
                            Map<String, String> paramDef = TagUtil.getParams( cell.getStringCellValue());
                            // s
                            Object result = parser.parse( sheet, cell, data);

                            // ʂ̒ǉ
                            if ( result != null) {
                                // p[^ResultKeyw肳ĂResultKeygpB
                                // w̏ꍇTag𗘗pB
                                String resultKey = parser.getTag();
                                if ( paramDef.containsKey( PARAM_RESULT_KEY)) {
                                    resultKey = paramDef.get( PARAM_RESULT_KEY);
                                }
                                sheetData.put( resultKey, result);
                            }
                            // p[Xʂ̃MO
                            if ( log.isInfoEnabled()) {
                                StringBuilder resultBuf = new StringBuilder( cell + "̏:");
                                if ( result instanceof Map) {
                                    Map<?, ?> mapResult = ( Map<?, ?>) result;
                                    Set<?> keyset = mapResult.keySet();
                                    for ( Object key : keyset) {
                                        resultBuf.append( "[" + key + ":" + mapResult.get( key) + "]");
                                    }
                                } else if ( result instanceof Collection) {
                                    Collection<?> listResult = ( Collection<?>) result;
                                    resultBuf.append( listResult.getClass() + " Size=" + listResult.size());
                                } else {
                                    resultBuf.append( result);
                                }
                                log.info( resultBuf.toString());
                            }

                            // ʃf[^lčŏI^OBŏI^Ȍꍇ͂̃^OŃV[g͔̏

                            if ( paramDef.containsKey( PARAM_LAST_TAG)) {
                                String strLastTag = paramDef.get( PARAM_LAST_TAG);
                                try {
                                    if ( Boolean.parseBoolean( strLastTag)) {
                                        return sheetData;
                                    }
                                } catch ( Exception e) {
                                    throw new ParseException( cell);
                                }
                            }
                        }
                    }
                }
            }
        }

        return sheetData;
    }

    /**
     * p[T̒ǉ
     * 
     * @param tagParser ΏۂTagParser
     */
    public void addTagParser( TagParser<?> tagParser) {
        tagParsers.add( tagParser);
    }

    /**
     * p[T̈ꗗ擾
     * 
     * @return ݐݒ肳Ăp[T̃Xg
     */
    public List<TagParser<?>> getTagParsers() {
        return tagParsers;
    }
}
