/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: WorkbookExporter.java 62 2009-05-21 07:35:40Z akira-yokoi $
 * $Revision: 62 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.exporter.book;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.util.PoiUtil;

/**
 * ͌(ubN)o͂NX
 * 
 * w肳ꂽpX(filePath)ɃubNo͂܂B
 * 
 * @since 1.0
 */
public class WorkbookExporter implements BookExporter {
	
    /**
     * K[
     */
    private static Log log = LogFactory.getLog( WorkbookExporter.class);

    /**
     * o͐t@CpX
     */
    private String filePath = null;

    /**
     * o͐t@CpX̎擾
     * 
     * @return o͐t@CpX
     */
    public String getFilePath() {
        return filePath;
    }

    /**
     * o͐t@CpX̐ݒ
     * 
     * @param filePath o͐t@CpX
     */
    public void setFilePath( String filePath) {
        this.filePath = filePath;
    }

    /**
     * 
     */
    public void setup() {
    }

    /**
     * s
     */
    public void export( Workbook book, BookData bookdata) throws ExportException {
        if ( log.isInfoEnabled()) {
            log.info( "ʂ" + filePath + "ɏo͂܂");
        }
        try {
            PoiUtil.writeBook( book, filePath);
        } catch ( Exception e) {
            throw new ExportException( e);
        }
    }

    /**
     * I
     */
    public void tearDown() {
    }
}
