/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ObjectsParser.java 92 2009-05-29 04:43:52Z yuta-takahashi $
 * $Revision: 92 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/**
 * p[XʂList&lt;Object&gt;ŕԋpp[T
 * 
 * @since 1.0
 */
public class ObjectsParser extends TagParser<List<Object>> {

    /**
     * NX`p[^
     */
    protected static final String PARAM_CLASS = "Class";

    /**
     * vpeBs̒p[^
     */
    protected static final String PARAM_PROPERTY_ROW = "PropertyRow";

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * ftHgvpeBsl
     */
    protected static final int DEFAULT_PROPERTY_ROW_ADJUST = 1;

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 2;

    /**
     * JX^vpeB̃Xg 
     */
    private List<ObjectsPropertyParser> customPropertyParsers = new ArrayList<ObjectsPropertyParser>();

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ObjectsParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data BookControllerparseBook(), parseSheet()\bhA 
     *              SheetParserparseSheet\bhňnꍇ
     *              TagParser܂ňp鏈f[^
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<Object> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        List<Object> resultList = new ArrayList<Object>();
        Class<?> clazz = null;

        // ^Os
        int tagRowIdx = tagCell.getRowIndex();
        // vpeBs
        int propertyRowIdx;
        // f[^Jns
        int valueRowFromIdx;
        // f[^Is
        int valueRowToIdx = sheet.getLastRowNum();

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            clazz = Class.forName( paramDef.get( PARAM_CLASS));

            // vpeBs̒
            propertyRowIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_PROPERTY_ROW, DEFAULT_PROPERTY_ROW_ADJUST);
            if ( propertyRowIdx < 0 || propertyRowIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_VALUE_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell);
            }

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

        // vpeBƑΉf[^^̃}bv
        Map<Integer, Class<?>> propertyClassMap = new HashMap<Integer, Class<?>>();
        // JCfbNXƃvpeB̃}bv
        Map<Integer, String> propertyNameMap = new HashMap<Integer, String>();
        // vpeBƃJX^p[T̃}bv
        Map<String, List<ObjectsPropertyParser>> customPropertyParserMap = new HashMap<String, List<ObjectsPropertyParser>>();

        // vpeBs̉
        List<Integer> targetColNums = new ArrayList<Integer>();
        Row propertyRow = sheet.getRow( propertyRowIdx);
        if ( propertyRow == null) {
            // vpeBsnull̏ꍇ
            return resultList;
        }
        int firstCellNum = propertyRow.getFirstCellNum();
        int lastCellNum = propertyRow.getLastCellNum();
        for ( int cellCnt = firstCellNum; cellCnt < lastCellNum; cellCnt++) {
            Cell cell = propertyRow.getCell( cellCnt);
            if ( cell == null) {
                continue;
            }
            try {
                String propertyName = cell.getStringCellValue();
                if ( propertyName.startsWith( BookController.COMMENT_PREFIX)) {
                    continue;
                }

                Object obj = clazz.newInstance();
                Class<?> propertyClass = PropertyUtils.getPropertyType( obj, propertyName);
                if ( propertyClass != null) {
                    propertyClassMap.put( cellCnt, propertyClass);
                    propertyNameMap.put( cellCnt, propertyName);
                    targetColNums.add( cellCnt);
                } else {
                    // vpeB珈Ώۂ̃p[T擾
                    for ( ObjectsPropertyParser parser : customPropertyParsers) {
                        if ( parser.isParse( sheet, cell)) {
                            List<ObjectsPropertyParser> propertyParsers = customPropertyParserMap.get( propertyName);
                            if ( propertyParsers == null) {
                                propertyParsers = new ArrayList<ObjectsPropertyParser>();
                            }
                            // 񓯂p[TĂ΂s̏C
                            if ( !propertyParsers.contains( parser)) {
                                propertyParsers.add( parser);                                
                            }
                            customPropertyParserMap.put( propertyName, propertyParsers);

                            if ( !targetColNums.contains( cellCnt)) {
                                propertyNameMap.put( cellCnt, propertyName);
                                targetColNums.add( cellCnt);
                            }
                        }
                    }
                }

            } catch ( Exception e) {
                throw new ParseException( cell, e);
            }
        }

        if ( targetColNums.size() > 0) {
            // Ώۗ񂪂ꍇ

            // f[^̉
            for ( int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; rowCnt++) {
                Row dataRow = sheet.getRow( rowCnt);
                if ( dataRow == null) {
                    continue;
                }
                Object obj;
                try {
                    obj = clazz.newInstance();
                    for ( Integer colCnt : targetColNums) {
                        Cell cell = dataRow.getCell( colCnt);

                        try {
                            Class<?> propertyClass = propertyClassMap.get( colCnt);
                            String propertyName = propertyNameMap.get( colCnt);
                            // JX^vpeB̔
                            if ( customPropertyParserMap.containsKey( propertyName)) {
                                List<ObjectsPropertyParser> propertyParsers = customPropertyParserMap.get( propertyName);
                                Map<String, String> params = TagUtil.getParams( propertyName);
                                Object cellValue = PoiUtil.getCellValue( cell);

                                // JX^p[T̏s
                                for ( ObjectsPropertyParser propertyParser : propertyParsers) {
                                    propertyParser.parse( obj, cellValue, TagUtil.getTag( propertyName), params);
                                }
                            } else {
                                Object value = null;
                                if ( cell != null) {
                                    value = PoiUtil.getCellValue( cell, propertyClass);
                                }
                                PropertyUtils.setProperty( obj, propertyName, value);
                            }
                        } catch ( Exception e) {
                            throw new ParseException( cell, e);
                        }
                    }
                } catch ( Exception e) {
                    if ( e instanceof ParseException) {
                        throw ( ParseException) e;
                    } else {
                        throw new ParseException( tagCell, e);
                    }
                }
                resultList.add( obj);
            }
        }
        return resultList;
    }

    /**
     * JX^vpeB̓NX̒ǉ
     * 
     * @param parser ǉJX^vpeB̓NX
     */
    public void addPropertyParser( ObjectsPropertyParser parser) {
        customPropertyParsers.add( parser);
    }

    /**
     * JX^vpeB̓NX̍폜
     * 
     * @param parser 폜JX^vpeB̓NX
     */
    public void removePropertyParser( ObjectsPropertyParser parser) {
        customPropertyParsers.remove( parser);
    }

    /**
     * JX^vpeB̓NXS폜
     */
    public void clearPropertyParsers() {
        customPropertyParsers.clear();
    }
}
