/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: TextFileExporterTest.java 2 2009-05-08 07:39:20Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.exporter.book;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * TextFileExportereXgNX
 * 
 * @since 1.0
 */
public class TextFileExporterTest {
    
    /**
     * ƃfBNg
     */
    private File workDire;
    
    /**
     * ƃfBNg쐬
     */
    private boolean result;

    @Before
    public void setUp() throws Exception {
        workDire = new File("TextFileExporterTestworkDire");
        result = workDire.mkdir();
        if (result) {
            System.out.println("ƃfBNg쐬 : " + workDire.getAbsolutePath());
        } else {
            System.out.println("ƃfBNg쐬ł܂łB : " + workDire.getAbsolutePath());
            System.out.println("eXgf");
        }
    }

    @After
    public void tearDown() throws Exception {
        if (result) {
            if (workDire.delete()) {
                System.out.println("ƃfBNg : " + workDire.getAbsolutePath());
            } else {
                System.out.println("ƃfBNgł܂łB : " + workDire.getAbsolutePath());
            }
        }
    }

    @Test
    public void testTextFileExporter() throws Exception {
        if (result) {
            Workbook book = null;
            String headFileName = "test";
            
            // sheetdata1쐬
            String sheetName1 = "sheetName1";
            SheetData sheetdata1 = new SheetData(sheetName1);
            String sheet1Tag = "sheet1Tag";
            List<Object> result1 = new ArrayList<Object>();
            result1.add( "vfP");
            result1.add( "vfQ");
            result1.add( "vfR");
            sheetdata1.put( sheet1Tag, result1);
            
            // sheetdata2쐬
            String sheetName2 = "sheetName2";
            SheetData sheetdata2 = new SheetData( sheetName2);
            String sheet2Tag = "sheet2Tag";
            List<Object> result2 = new ArrayList<Object>();
            result2.add( "vfS");
            result2.add( "vfT");
            result2.add( "vfU");
            sheetdata2.put( sheet2Tag, result2);

            // bookdata쐬
            BookData bookdata = new BookData();
            bookdata.putSheetData( sheetName1, sheetdata1);
            bookdata.putSheetData( sheetName2, sheetdata2);
            
            
            //No.1 탋[g(directoryPathݒ)
            File test1File1 = null;
            BufferedReader test1reader1 = null;
            File test1File2 = null;
            BufferedReader test1reader2 = null;
            try {
                TextFileExporter exporter = new TextFileExporter();
                exporter.setDirectoryPath( workDire.getPath());
                exporter.setup();
                exporter.export( book, bookdata);
                exporter.tearDown();

                //sheetdata1
                test1File1 = new File( workDire.getPath(), sheetName1 + ".txt");
                test1reader1 = new BufferedReader( new FileReader( test1File1));

                assertEquals( "=====================" + sheetName1 + "=====================", test1reader1.readLine());
                assertEquals( "\t" + sheet1Tag + "\t" + sheetdata1.get( sheet1Tag), test1reader1.readLine());
                assertNull( test1reader1.readLine());

                //sheetdata2
                test1File2 = new File( workDire.getPath(), sheetName2 + ".txt");
                test1reader2 = new BufferedReader( new FileReader( test1File2));

                assertEquals( "=====================" + sheetName2 + "=====================", test1reader2.readLine());
                assertEquals( "\t" + sheet2Tag + "\t" + sheetdata2.get( sheet2Tag), test1reader2.readLine());
                assertNull( test1reader2.readLine());

            } finally {
                test1reader1.close();
                test1File1.delete();
                test1reader2.close();
                test1File2.delete();
            }

            //No.2 탋[g(baseFilePathݒ)
            File test2File1 = null;
            BufferedReader test2reader1 = null;
            File test2File2 = null;
            BufferedReader test2reader2 = null;
            try {
                TextFileExporter exporter = new TextFileExporter();
                exporter.setBaseFilePath( workDire.getPath() + File.separatorChar + headFileName);
                exporter.setup();
                exporter.export( book, bookdata);
                exporter.tearDown();

                //sheetdata1
                test2File1 = new File( workDire.getPath(), headFileName + sheetName1 + ".txt");
                test2reader1 = new BufferedReader( new FileReader( test2File1));

                assertEquals( "=====================" + sheetName1 + "=====================", test2reader1.readLine());
                assertEquals( "\t" + sheet1Tag + "\t" + sheetdata1.get( sheet1Tag), test2reader1.readLine());
                assertNull( test2reader1.readLine());

                //sheetdata2
                test2File2 = new File( workDire.getPath(), headFileName + sheetName2 + ".txt");
                test2reader2 = new BufferedReader( new FileReader( test2File2));

                assertEquals( "=====================" + sheetName2 + "=====================", test2reader2.readLine());
                assertEquals( "\t" + sheet2Tag + "\t" + sheetdata2.get( sheet2Tag), test2reader2.readLine());
                assertNull( test2reader2.readLine());

            } finally {
                test2reader1.close();
                test2File1.delete();
                test2reader2.close();
                test2File2.delete();
            }

            //No.3 탋[g(directoryPathAbaseFilePathݒ)
            File test3File1dir = null;
            BufferedReader test3reader1dir = null;
            File test3File2dir = null;
            BufferedReader test3reader2dir = null;
            File test3File1base = null;
            BufferedReader test3reader1base = null;
            File test3File2base = null;
            BufferedReader test3reader2base = null;
            try {
                TextFileExporter exporter = new TextFileExporter();
                exporter.setDirectoryPath( workDire.getPath());
                exporter.setBaseFilePath( workDire.getPath() + File.separatorChar + headFileName);
                exporter.setup();
                exporter.export( book, bookdata);
                exporter.tearDown();

                //sheetdata1
                test3File1dir = new File( workDire.getPath(), sheetName1 + ".txt");
                test3reader1dir = new BufferedReader( new FileReader( test3File1dir));

                assertEquals( "=====================" + sheetName1 + "=====================", test3reader1dir.readLine());
                assertEquals( "\t" + sheet1Tag + "\t" + sheetdata1.get( sheet1Tag), test3reader1dir.readLine());
                assertNull( test3reader1dir.readLine());

                test3File1base = new File( workDire.getPath(), headFileName + sheetName1 + ".txt");
                test3reader1base = new BufferedReader( new FileReader( test3File1base));

                assertEquals( "=====================" + sheetName1 + "=====================", test3reader1base.readLine());
                assertEquals( "\t" + sheet1Tag + "\t" + sheetdata1.get( sheet1Tag), test3reader1base.readLine());
                assertNull( test3reader1base.readLine());

                //sheetdata2
                test3File2dir = new File( workDire.getPath(), sheetName2 + ".txt");
                test3reader2dir = new BufferedReader( new FileReader( test3File2dir));

                assertEquals( "=====================" + sheetName2 + "=====================", test3reader2dir.readLine());
                assertEquals( "\t" + sheet2Tag + "\t" + sheetdata2.get( sheet2Tag), test3reader2dir.readLine());
                assertNull( test3reader2dir.readLine());

                test3File2base = new File( workDire.getPath(), headFileName + sheetName2 + ".txt");
                test3reader2base = new BufferedReader( new FileReader( test3File2base));

                assertEquals( "=====================" + sheetName2 + "=====================", test3reader2base.readLine());
                assertEquals( "\t" + sheet2Tag + "\t" + sheetdata2.get( sheet2Tag), test3reader2base.readLine());
                assertNull( test3reader2base.readLine());

                assertEquals( workDire.getPath(), exporter.getDirectoryPath());
                assertEquals( workDire.getPath() + File.separatorChar + headFileName, exporter.getBaseFilePath());

            } finally {
                test3reader1dir.close();
                test3File1dir.delete();
                test3reader1base.close();
                test3File1base.delete();

                test3reader2dir.close();
                test3File2dir.delete();
                test3reader2base.close();
                test3File2base.delete();
            }

            //No.4 s[g(directoryPathAbaseFilePathݒ薳)
            TextFileExporter exporter4 = new TextFileExporter();
            exporter4.setup();
            exporter4.export( book, bookdata);
            exporter4.tearDown();

            //No.5 s[g(baseFilePathfBNĝ݂ݒ)
            try {
                TextFileExporter exporter = new TextFileExporter();
                exporter.setBaseFilePath( workDire.getPath());
                exporter.setup();
                exporter.export( book, bookdata);
                exporter.tearDown();
                fail();

            } catch ( ExportException ee) {
                System.out.println( ee);
            }

            //No.6 s[g(directoryPathݒ葶݂ȂpX)
            try {
                TextFileExporter exporter = new TextFileExporter();
                exporter.setDirectoryPath( workDire.getPath() + File.separatorChar + "dir");
                exporter.setup();
                exporter.export( book, bookdata);
                exporter.tearDown();
                fail();

            } catch ( ExportException ee) {
                System.out.println( ee);
            }

        } else {
            fail();
        }
    }

}
