/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: MapParserTest.java 128 2009-07-02 06:32:17Z yuta-takahashi $
 * $Revision: 128 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Map;
import java.util.Set;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.WorkbookTest;
import org.bbreak.excella.core.exception.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * MapParsereXgNX
 * 
 * @since 1.0
 */
public class MapParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public MapParserTest( String version) {
        super( version);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testMapParser() throws ParseException {
        Workbook wk = getWorkbook();
        Sheet sheet1 = wk.getSheetAt( 0);
        Sheet sheet2 = wk.getSheetAt( 1);
        Sheet sheet3 = wk.getSheetAt( 2);
        Sheet sheet4 = wk.getSheetAt( 3);
        MapParser mapParser = new MapParser( "@Map");
        Cell tagCell = null;
        Object data = null;
        Map<?, ?> map = null;

        // No.1 p[^
        tagCell = sheet1.getRow( 3).getCell( 0);
        map = mapParser.parse( sheet1, tagCell, data);
        Set<?> keySet = map.keySet();
        assertEquals( 25, keySet.size());
        assertEquals( "l1", map.get( "L[1"));
        assertEquals( "l2", map.get( "L[2"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=5}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=5}"));
        assertEquals( "l3", map.get( "L[3"));
        assertEquals( "l4", map.get( "L[4"));
        assertEquals( "l5", map.get( "L[5"));
        assertEquals( "l6", map.get( "L[6"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=3,Key=L[}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=3,Key=L[}"));
        assertEquals( "l7", map.get( "L[7"));
        assertEquals( "l8", map.get( "L[8"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=3,Value=l}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=3,Value=l}"));
        assertEquals( "l9", map.get( "L[9"));
        assertEquals( "l10", map.get( "L[10"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=3,KeyColumn=2}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=3,KeyColumn=2}"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=3,ValueColumn=2}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=3,ValueColumn=2}"));
        assertEquals( "l", map.get( "L[13"));
        assertEquals( "l", map.get( "L[14"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=4,KeyCell=2:2}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=4,KeyCell=2:2}"));
        assertEquals( "l17", map.get( "l"));
        assertTrue( keySet.contains( "@Map{DataRowFrom=2,DataRowTo=4,ValueCell=4:3}"));
        assertEquals( null, map.get( "@Map{DataRowFrom=2,DataRowTo=4,ValueCell=4:3}"));
        assertEquals( "l", map.get( "L[18"));
        assertEquals( "l", map.get( "L[19"));
        assertEquals( "l", map.get( "L[20"));

        // No.2 p[^L
        tagCell = sheet1.getRow( 7).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 4, keySet.size());
        assertEquals( "l3", map.get( "L[3"));
        assertEquals( "l4", map.get( "L[4"));
        assertEquals( "l5", map.get( "L[5"));
        assertEquals( "l6", map.get( "L[6"));

        // No.3 L[w
        tagCell = sheet1.getRow( 15).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 1, keySet.size());
        assertEquals( "l8", map.get( "L["));

        // No.4 lw
        tagCell = sheet1.getRow( 24).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( "l", map.get( "L[9"));
        assertEquals( "l", map.get( "L[10"));

        // No.5 L[w
        tagCell = sheet1.getRow( 32).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( "l11", map.get( "L[11"));
        assertEquals( "l12", map.get( "L[12"));

        // No.6 lw
        tagCell = sheet1.getRow( 41).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( "l13", map.get( "L[13"));
        assertEquals( "l14", map.get( "L[14"));

        // No.7 L[Zw
        tagCell = sheet1.getRow( 49).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 1, keySet.size());
        assertEquals( "l17", map.get( "L[15"));

        // No.8 lZw
        tagCell = sheet1.getRow( 58).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l20", map.get( "L[18"));
        assertEquals( "l20", map.get( "L[19"));
        assertEquals( "l20", map.get( "L[20"));

        // No.9 DataRowFrom > DataRowTo
        tagCell = sheet1.getRow( 3).getCell( 7);
        map.clear();
        try {
            map = mapParser.parse( sheet1, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 3, cell.getRow().getRowNum());
            assertEquals( 7, cell.getColumnIndex());
            System.out.println( "No.9:" + pe);
        }

        // No.10 }CiX͈͎w
        tagCell = sheet1.getRow( 18).getCell( 7);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 4, keySet.size());
        assertEquals( "l5", map.get( "L[5"));
        assertEquals( "l6", map.get( "L[6"));
        assertEquals( "l7", map.get( "L[7"));
        assertEquals( "l8", map.get( "L[8"));

        // No.11 L[}CiXw
        tagCell = sheet1.getRow( 23).getCell( 8);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 4, keySet.size());
        assertEquals( "l9", map.get( "L[9"));
        assertEquals( "l10", map.get( "L[10"));
        assertEquals( "l11", map.get( "L[11"));
        assertEquals( "l12", map.get( "L[12"));

        // No.12 l}CiXw
        tagCell = sheet1.getRow( 33).getCell( 8);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 4, keySet.size());
        assertEquals( "l13", map.get( "L[13"));
        assertEquals( "l14", map.get( "L[14"));
        assertEquals( "l15", map.get( "L[15"));
        assertEquals( "l16", map.get( "L[16"));

        // No.13 L[Z}CiXw
        tagCell = sheet1.getRow( 43).getCell( 8);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 1, keySet.size());
        assertEquals( "l20", map.get( "L["));

        // No.14 lZ}CiXw
        tagCell = sheet1.getRow( 53).getCell( 8);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 4, keySet.size());
        assertEquals( "l", map.get( "L[21"));
        assertEquals( "l", map.get( "L[22"));
        assertEquals( "l", map.get( "L[23"));
        assertEquals( "l", map.get( "L[24"));

        // No.15 L[El𓯗Ɏw
        tagCell = sheet1.getRow( 63).getCell( 7);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( "L[El25", map.get( "L[El25"));
        assertEquals( "L[El26", map.get( "L[El26"));

        // No.16 L[ElɃ^OƓsEw
        tagCell = sheet1.getRow( 71).getCell( 7);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 1, keySet.size());
        assertEquals( "@Map{DataRowFrom=0,DataRowTo=0,ValueColumn=0}", map.get( "@Map{DataRowFrom=0,DataRowTo=0,ValueColumn=0}"));

        // No.17 L[ElZɃ^OZw
        tagCell = sheet1.getRow( 76).getCell( 7);
        map.clear();
        map = mapParser.parse( sheet1, tagCell, data);
        keySet = map.keySet();
        assertEquals( 1, keySet.size());
        assertEquals( "@Map{DataRowFrom=0,DataRowTo=0,KeyCell=0:0,ValueCell=0:0}", map.get( "@Map{DataRowFrom=0,DataRowTo=0,KeyCell=0:0,ValueCell=0:0}"));

        // No.18 L[Znull
        tagCell = sheet2.getRow( 3).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l1", map.get( "L[1"));
        assertTrue( keySet.contains( null));
        assertEquals( "l2", map.get( null));
        assertEquals( "l3", map.get( "L[2"));

        // No.19 lZnull
        tagCell = sheet2.getRow( 11).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l4", map.get( "L[3"));
        assertEquals( null, map.get( "L[4"));
        assertEquals( "l5", map.get( "L[5"));

        // No.20 f[^snull
        tagCell = sheet2.getRow( 19).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( "l6", map.get( "L[6"));
        assertEquals( "l7", map.get( "L[7"));

        // No.21 L[Zlnull
        tagCell = sheet2.getRow( 27).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l8", map.get( "L[8"));
        assertEquals( "l9", map.get( null));
        assertEquals( "l10", map.get( "L[9"));

        // No.22 lZ̒lnull
        tagCell = sheet2.getRow( 35).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l11", map.get( "L[10"));
        assertTrue( keySet.contains( "L[11"));
        assertEquals( null, map.get( "L[11"));
        assertEquals( "l12", map.get( "L[12"));

        // No.23 L[Z̒lElZ̒lnull
        tagCell = sheet2.getRow( 43).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 3, keySet.size());
        assertEquals( "l13", map.get( "L[13"));
        assertTrue( keySet.contains( null));
        assertEquals( null, map.get( null));
        assertEquals( "l14", map.get( "L[14"));

        // No.24 lZ̍snull
        tagCell = sheet2.getRow( 51).getCell( 0);
        map.clear();
        map = mapParser.parse( sheet2, tagCell, data);
        keySet = map.keySet();
        assertEquals( 2, keySet.size());
        assertEquals( null, map.get( "L[15"));
        assertEquals( null, map.get( "L[16"));

        // No.25 d`FKey, KeyColumn, KeyCell
        tagCell = sheet3.getRow( 4).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 4, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.25:" + pe);
        }

        // No.26 d`FKey, KeyColumn
        tagCell = sheet3.getRow( 8).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 8, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.26:" + pe);
        }

        // No.27 d`FKey, KeyCell
        tagCell = sheet3.getRow( 12).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 12, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.27:" + pe);
        }

        // No.28 d`FKeyColumn, KeyCell
        tagCell = sheet3.getRow( 16).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet1, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 16, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.28:" + pe);
        }

        // No.29 d`FValue, ValueColumn, ValueCell
        tagCell = sheet3.getRow( 20).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 20, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.29:" + pe);
        }

        // No.30 d`FValue, ValueColumn
        tagCell = sheet3.getRow( 24).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 24, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.30:" + pe);
        }

        // No.31 d`FValue, ValueCell
        tagCell = sheet3.getRow( 28).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 28, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.31:" + pe);
        }

        // No.32 d`FValueColumn, ValueCell
        tagCell = sheet3.getRow( 32).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 32, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.32:" + pe);
        }

        // No.33 f[^
        tagCell = sheet3.getRow( 38).getCell( 1);
        map.clear();
        map = mapParser.parse( sheet3, tagCell, data);

        // No.34 DataRowFromsilj
        tagCell = sheet3.getRow( 41).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 41, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.33:" + pe);
        }

        // No.35 DataRowTosilj
        tagCell = sheet3.getRow( 44).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 44, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.35:" + pe);
        }

        // No.36 Keysilj
        tagCell = sheet3.getRow( 47).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 47, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.36:" + pe);
        }

        // No.37 Valuesilj
        tagCell = sheet3.getRow( 50).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 50, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.37:" + pe);
        }

        // No.38 KeyColumnsilj
        tagCell = sheet3.getRow( 53).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 53, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.38:" + pe);
        }

        // No.39 ValueColumnsilj
        tagCell = sheet3.getRow( 56).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 56, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.39:" + pe);
        }

        // No.40 KeyCellsilj
        tagCell = sheet3.getRow( 59).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 59, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.40:" + pe);
        }

        // No.41 ValueCellsilj
        tagCell = sheet3.getRow( 62).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 62, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.41:" + pe);
        }

        // No.42 DataRowFromsilj
        tagCell = sheet3.getRow( 65).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 65, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.42:" + pe);
        }

        // No.43 DataRowTosilj
        tagCell = sheet3.getRow( 68).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 68, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.43:" + pe);
        }

        // No.44 KeyColumensilj
        tagCell = sheet3.getRow( 71).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 71, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.44:" + pe);
        }

        // No.45 ValueColumnsilj
        tagCell = sheet3.getRow( 74).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 74, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.45:" + pe);
        }

        // No.46 KeyCellsilj
        tagCell = sheet3.getRow( 77).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 77, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.46:" + pe);
        }

        // No.47 ValueCellsilj
        tagCell = sheet3.getRow( 80).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 80, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.47:" + pe);
        }

        // No.48 KeyColumnseXgiAŃL[Ƀ}CiXwj
        tagCell = sheet4.getRow( 2).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.48:" + pe);
        }

        // No.49 ValueColumnseXgiAŒlɃ}CiXwj
        tagCell = sheet4.getRow( 11).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 11, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.49:" + pe);
        }

        // No.50 KeyCellseXgiAŃL[ZɃ}CiXwj
        tagCell = sheet4.getRow( 20).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 20, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.50:" + pe);
        }

        // No.51 ValueCellseXgiAŒlZɃ}CiXwj
        tagCell = sheet4.getRow( 29).getCell( 0);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 29, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.51:" + pe);
        }

        // No.52 DataRowFromseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 3);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
            System.out.println( "No.52:" + pe);
        }

        // No.53 DataRowToseXgi1sڂŃf[^IsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 6);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 6, cell.getColumnIndex());
            System.out.println( "No.53:" + pe);
        }

        // No.54 KeyCellseXgi1sڂŃL[ZsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 9);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 9, cell.getColumnIndex());
            System.out.println( "No.54:" + pe);
        }

        // No.55 ValueCellseXgi1sڂŒlZsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 12);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 12, cell.getColumnIndex());
            System.out.println( "No.55:" + pe);
        }

        // No.56 KeyColumnseXgiŏIŃL[ɃvXݒj
        tagCell = sheet4.getRow( 3).getCell( 16);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 3, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
            System.out.println( "No.56:" + pe);
        }

        // No.57 ValueColumnseXgiŏIŒlɃvXݒj
        tagCell = sheet4.getRow( 12).getCell( 16);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 12, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
            System.out.println( "No.57:" + pe);
        }

        // No.58 KeyCellseXgiŏIŃL[ZɃvXݒj
        tagCell = sheet4.getRow( 21).getCell( 16);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 21, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
            System.out.println( "No.58:" + pe);
        }

        // No.59 ValueCellseXgiŏIŒlZɃvXݒj
        tagCell = sheet4.getRow( 30).getCell( 16);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 30, cell.getRow().getRowNum());
            assertEquals( 16, cell.getColumnIndex());
            System.out.println( "No.59:" + pe);
        }

        // No.60 DataRowFromseXgiŏIsŃf[^JnsɃvXݒj
        tagCell = sheet4.getRow( 34).getCell( 3);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 34, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
            System.out.println( "No.60:" + pe);
        }

        // No.61 DataRowToseXgiŏIsŃf[^IsɃvXݒj
        tagCell = sheet4.getRow( 34).getCell( 6);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 34, cell.getRow().getRowNum());
            assertEquals( 6, cell.getColumnIndex());
            System.out.println( "No.61:" + pe);
        }

        // No.62 KeyCellseXgiŏIsŃL[ZsɃvXݒj
        tagCell = sheet4.getRow( 34).getCell( 9);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 34, cell.getRow().getRowNum());
            assertEquals( 9, cell.getColumnIndex());
            System.out.println( "No.62:" + pe);
        }

        // No.63 ValueCellseXgiŏIsŒlZsɃvXݒj
        tagCell = sheet4.getRow( 34).getCell( 12);
        map.clear();
        try {
            map = mapParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 34, cell.getRow().getRowNum());
            assertEquals( 12, cell.getColumnIndex());
            System.out.println( "No.63:" + pe);
        }
    }
}
