/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PoiUtil {
    public static final String TMP_SHEET_NAME = "-@%delete%_tmpSheet";

    private PoiUtil() {
    }

    public static Object getCellValue(Cell cell) {
        Object value;
        block19: {
            value = null;
            if (cell == null) break block19;
            block0 : switch (cell.getCellType()) {
                case 3: {
                    break;
                }
                case 4: {
                    value = cell.getBooleanCellValue();
                    break;
                }
                case 5: {
                    value = cell.getErrorCellValue();
                    break;
                }
                case 0: {
                    if (PoiUtil.isCellDateFormatted(cell)) {
                        value = cell.getDateCellValue();
                        break;
                    }
                    value = cell.getNumericCellValue();
                    break;
                }
                case 1: {
                    value = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                    CellValue cellValue = evaluator.evaluate(cell);
                    int cellType = cellValue.getCellType();
                    switch (cellType) {
                        case 3: {
                            break block0;
                        }
                        case 4: {
                            value = cell.getBooleanCellValue();
                            break block0;
                        }
                        case 5: {
                            if (cell instanceof XSSFCell) {
                                XSSFCell xssfCell = (XSSFCell)cell;
                                CTCell ctCell = xssfCell.getCTCell();
                                value = ctCell.getV();
                                break block0;
                            }
                            if (cell instanceof HSSFCell) {
                                value = cell.getErrorCellValue();
                                break block0;
                            }
                            break block19;
                        }
                        case 0: {
                            if (PoiUtil.isCellDateFormatted(cell)) {
                                value = cell.getDateCellValue();
                                break block0;
                            }
                            value = cell.getNumericCellValue();
                            break block0;
                        }
                        case 1: {
                            value = cell.getStringCellValue();
                        }
                    }
                }
            }
        }
        return value;
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            String fs = style.getDataFormatString();
            if (fs != null) {
                int endIdx;
                int beginIdx;
                while (fs.contains("\"") && (beginIdx = fs.indexOf("\"")) != -1 && (endIdx = fs.indexOf("\"", beginIdx + 1)) != -1) {
                    fs = fs.replaceFirst(fs.substring(beginIdx, endIdx + 1), "");
                }
            }
            bDate = DateUtil.isADateFormat((int)i, (String)fs);
        }
        return bDate;
    }

    public static Date getJavaDate(double excelDate) {
        return DateUtil.getJavaDate((double)excelDate);
    }

    public static Object getCellValue(Sheet sheet, int rowIndex, int columnIndex) {
        Cell cell;
        Object value = null;
        Row row = sheet.getRow(rowIndex);
        if (row != null && (cell = row.getCell(columnIndex)) != null) {
            value = PoiUtil.getCellValue(cell);
        }
        return value;
    }

    public static Object getCellValue(Cell cell, Class<?> propertyClass) {
        if (cell.getCellType() == 3) {
            return null;
        }
        if (Object.class.isAssignableFrom(propertyClass)) {
            if (Number.class.isAssignableFrom(propertyClass)) {
                Double number = cell.getNumericCellValue();
                if (propertyClass.equals(Short.class)) {
                    return ((Number)number).shortValue();
                }
                if (propertyClass.equals(Integer.class)) {
                    return ((Number)number).intValue();
                }
                if (propertyClass.equals(Long.class)) {
                    return ((Number)number).longValue();
                }
                if (propertyClass.equals(Float.class)) {
                    return Float.valueOf(((Number)number).floatValue());
                }
                if (propertyClass.equals(Double.class)) {
                    return (double)number;
                }
                if (propertyClass.equals(BigDecimal.class)) {
                    return new BigDecimal(number);
                }
                if (propertyClass.equals(Byte.class)) {
                    return new Byte(((Number)number).byteValue());
                }
                return number;
            }
            if (Date.class.isAssignableFrom(propertyClass)) {
                return cell.getDateCellValue();
            }
            if (String.class.isAssignableFrom(propertyClass)) {
                Object value = PoiUtil.getCellValue(cell);
                if (value == null) {
                    return null;
                }
                String strValue = null;
                if (value instanceof String) {
                    strValue = (String)value;
                }
                strValue = value instanceof Double ? String.valueOf(((Double)value).intValue()) : value.toString();
                return strValue;
            }
            if (Boolean.class.isAssignableFrom(propertyClass) || Boolean.TYPE.isAssignableFrom(propertyClass)) {
                Object value = PoiUtil.getCellValue(cell);
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    return Boolean.valueOf((String)value);
                }
                return value;
            }
        } else {
            Object value = PoiUtil.getCellValue(cell);
            if (value == null) {
                return null;
            }
            if (value instanceof Double) {
                if (Byte.TYPE.isAssignableFrom(propertyClass)) {
                    int intValue = Double.valueOf((Double)value).intValue();
                    value = Byte.valueOf(String.valueOf(intValue));
                } else if (Short.TYPE.isAssignableFrom(propertyClass)) {
                    value = Double.valueOf((Double)value).shortValue();
                } else if (Integer.TYPE.isAssignableFrom(propertyClass)) {
                    value = Double.valueOf((Double)value).intValue();
                } else if (Long.TYPE.isAssignableFrom(propertyClass)) {
                    value = Double.valueOf((Double)value).longValue();
                } else if (Float.TYPE.isAssignableFrom(propertyClass)) {
                    value = Float.valueOf(Double.valueOf((Double)value).floatValue());
                } else if (Double.TYPE.isAssignableFrom(propertyClass)) {
                    value = (double)((Double)value);
                }
            }
            return value;
        }
        return null;
    }

    public static String getSheetName(Cell cell) {
        Sheet sheet = cell.getSheet();
        return PoiUtil.getSheetName(sheet);
    }

    public static String getSheetName(Sheet sheet) {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet);
        return workbook.getSheetName(sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBook(Workbook workbook, String filename) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(filename);
        try {
            workbook.write((OutputStream)fileOut);
        }
        finally {
            fileOut.close();
        }
    }

    public static void copyCell(Cell fromCell, Cell toCell) {
        if (fromCell != null) {
            int cellType = fromCell.getCellType();
            switch (cellType) {
                case 3: {
                    break;
                }
                case 2: {
                    String cellFormula = fromCell.getCellFormula();
                    toCell.setCellFormula(cellFormula);
                    break;
                }
                case 4: {
                    toCell.setCellValue(fromCell.getBooleanCellValue());
                    break;
                }
                case 5: {
                    toCell.setCellErrorValue(fromCell.getErrorCellValue());
                    break;
                }
                case 0: {
                    toCell.setCellValue(fromCell.getNumericCellValue());
                    break;
                }
                case 1: {
                    toCell.setCellValue(fromCell.getRichStringCellValue());
                    break;
                }
            }
            if (fromCell.getCellStyle() != null) {
                toCell.setCellStyle(fromCell.getCellStyle());
            }
            if (fromCell.getCellComment() != null) {
                toCell.setCellComment(fromCell.getCellComment());
            }
        }
    }

    public static void copyRange(Sheet fromSheet, CellRangeAddress rangeAddress, Sheet toSheet, int toRowNum, int toColumnNum, boolean clearFromRange) {
        if (fromSheet == null || rangeAddress == null || toSheet == null) {
            return;
        }
        int fromRowIndex = rangeAddress.getFirstRow();
        int fromColumnIndex = rangeAddress.getFirstColumn();
        int rowNumOffset = toRowNum - fromRowIndex;
        int columnNumOffset = toColumnNum - fromColumnIndex;
        CellRangeAddress toAddress = new CellRangeAddress(rangeAddress.getFirstRow() + rowNumOffset, rangeAddress.getLastRow() + rowNumOffset, rangeAddress.getFirstColumn() + columnNumOffset, rangeAddress.getLastColumn() + columnNumOffset);
        Workbook fromWorkbook = fromSheet.getWorkbook();
        Sheet baseSheet = fromSheet;
        Sheet tmpSheet = null;
        if (fromSheet.equals(toSheet) && PoiUtil.crossRangeAddress(rangeAddress, toAddress)) {
            tmpSheet = fromWorkbook.getSheet(TMP_SHEET_NAME);
            if (tmpSheet == null) {
                tmpSheet = fromWorkbook.createSheet(TMP_SHEET_NAME);
            }
            baseSheet = tmpSheet;
            PoiUtil.copyRange(fromSheet, rangeAddress, tmpSheet, rangeAddress.getFirstRow(), rangeAddress.getFirstColumn(), false);
            if (clearFromRange) {
                PoiUtil.clearRange(fromSheet, rangeAddress);
            }
        }
        Set<CellRangeAddress> targetCellSet = PoiUtil.getMergedAddress(baseSheet, rangeAddress);
        PoiUtil.clearRange(toSheet, toAddress);
        for (CellRangeAddress mergeAddress : targetCellSet) {
            toSheet.addMergedRegion(new CellRangeAddress(mergeAddress.getFirstRow() + rowNumOffset, mergeAddress.getLastRow() + rowNumOffset, mergeAddress.getFirstColumn() + columnNumOffset, mergeAddress.getLastColumn() + columnNumOffset));
        }
        block3: for (int i = rangeAddress.getFirstRow(); i <= rangeAddress.getLastRow(); ++i) {
            Row fromRow = baseSheet.getRow(i);
            if (fromRow == null) continue;
            Row row = toSheet.getRow(i + rowNumOffset);
            if (row == null) {
                row = toSheet.createRow(i + rowNumOffset);
                row.setHeight((short)0);
            }
            short fromRowHeight = fromRow.getHeight();
            short toRowHeight = row.getHeight();
            if (toRowHeight < fromRowHeight) {
                row.setHeight(fromRow.getHeight());
            }
            ColumnHelper columnHelper = null;
            if (toSheet instanceof XSSFSheet) {
                XSSFSheet xssfSheet = (XSSFSheet)toSheet.getWorkbook().getSheetAt(toSheet.getWorkbook().getSheetIndex(toSheet));
                CTWorksheet ctWorksheet = xssfSheet.getCTWorksheet();
                columnHelper = new ColumnHelper(ctWorksheet);
            }
            for (int j = rangeAddress.getFirstColumn(); j <= rangeAddress.getLastColumn(); ++j) {
                Cell fromCell = fromRow.getCell(j);
                if (fromCell == null) continue;
                int maxColumn = SpreadsheetVersion.EXCEL97.getMaxColumns();
                if (toSheet instanceof XSSFSheet) {
                    maxColumn = SpreadsheetVersion.EXCEL2007.getMaxColumns();
                }
                if (j + columnNumOffset >= maxColumn) continue block3;
                Cell cell = row.getCell(j + columnNumOffset);
                if (cell == null) {
                    CTCol col;
                    cell = row.createCell(j + columnNumOffset);
                    if (toSheet instanceof XSSFSheet && ((col = columnHelper.getColumn((long)cell.getColumnIndex(), false)) == null || !col.isSetWidth())) {
                        toSheet.setColumnWidth(cell.getColumnIndex(), baseSheet.getColumnWidth(j));
                    }
                }
                PoiUtil.copyCell(fromCell, cell);
                try {
                    int fromColumnWidth = baseSheet.getColumnWidth(j);
                    int toColumnWidth = toSheet.getColumnWidth(j + columnNumOffset);
                    if (toColumnWidth >= fromColumnWidth) continue;
                    toSheet.setColumnWidth(j + columnNumOffset, baseSheet.getColumnWidth(j));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
        }
        if (tmpSheet != null) {
            if (!(fromWorkbook instanceof XSSFWorkbook)) {
                fromWorkbook.removeSheetAt(fromWorkbook.getSheetIndex(tmpSheet));
            }
        } else if (clearFromRange) {
            PoiUtil.clearRange(fromSheet, rangeAddress);
        }
    }

    public static void insertRangeDown(Sheet sheet, CellRangeAddress rangeAddress) {
        int rangeLastRowNum = PoiUtil.getLastRowNum(sheet, rangeAddress.getFirstColumn(), rangeAddress.getLastColumn());
        if (rangeLastRowNum != -1 && rangeAddress.getFirstRow() <= rangeLastRowNum) {
            CellRangeAddress fromAddress = new CellRangeAddress(rangeAddress.getFirstRow(), rangeLastRowNum, rangeAddress.getFirstColumn(), rangeAddress.getLastColumn());
            PoiUtil.copyRange(sheet, fromAddress, sheet, rangeAddress.getLastRow() + 1, rangeAddress.getFirstColumn(), true);
        }
    }

    public static int getLastRowNum(Sheet sheet, int firstColumnIndex, int lastColmunIndex) {
        int sheetLastRowNum = sheet.getLastRowNum();
        int rangeLastRowNum = -1;
        for (int i = sheetLastRowNum; 0 <= i; --i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (Cell cell : row) {
                if (cell == null || firstColumnIndex > cell.getColumnIndex() || cell.getColumnIndex() > lastColmunIndex) continue;
                rangeLastRowNum = i;
                break;
            }
            if (rangeLastRowNum != -1) break;
        }
        return rangeLastRowNum;
    }

    public static void insertRangeRight(Sheet sheet, CellRangeAddress rangeAddress) {
        int rangeLastColumn = PoiUtil.getLastColumnNum(sheet, rangeAddress.getFirstRow(), rangeAddress.getLastRow());
        if (rangeLastColumn != -1 && rangeAddress.getFirstColumn() <= rangeLastColumn) {
            CellRangeAddress fromAddress = new CellRangeAddress(rangeAddress.getFirstRow(), rangeAddress.getLastRow(), rangeAddress.getFirstColumn(), rangeLastColumn);
            PoiUtil.copyRange(sheet, fromAddress, sheet, rangeAddress.getFirstRow(), rangeAddress.getLastColumn() + 1, true);
        }
    }

    public static int getLastColumnNum(Sheet sheet, int firstRowIndex, int lastRowIndex) {
        int rangeLastColumn = -1;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (Cell cell : row) {
                if (cell == null || rangeLastColumn >= cell.getColumnIndex()) continue;
                rangeLastColumn = cell.getColumnIndex();
            }
        }
        return rangeLastColumn;
    }

    public static void deleteRangeUp(Sheet sheet, CellRangeAddress rangeAddress) {
        int rangeLastRowNum = PoiUtil.getLastRowNum(sheet, rangeAddress.getFirstColumn(), rangeAddress.getLastColumn());
        if (rangeLastRowNum != -1 && rangeAddress.getFirstRow() <= rangeLastRowNum) {
            CellRangeAddress fromAddress = new CellRangeAddress(rangeAddress.getLastRow() + 1, rangeLastRowNum, rangeAddress.getFirstColumn(), rangeAddress.getLastColumn());
            PoiUtil.copyRange(sheet, fromAddress, sheet, rangeAddress.getFirstRow(), rangeAddress.getFirstColumn(), true);
        }
    }

    public static void deleteRangeLeft(Sheet sheet, CellRangeAddress rangeAddress) {
        int rangeLastColumn = PoiUtil.getLastColumnNum(sheet, rangeAddress.getFirstRow(), rangeAddress.getLastRow());
        if (rangeLastColumn != -1 && rangeAddress.getFirstColumn() <= rangeLastColumn) {
            CellRangeAddress fromAddress = new CellRangeAddress(rangeAddress.getFirstRow(), rangeAddress.getLastRow(), rangeAddress.getLastColumn() + 1, rangeLastColumn);
            PoiUtil.copyRange(sheet, fromAddress, sheet, rangeAddress.getFirstRow(), rangeAddress.getFirstColumn(), true);
        }
    }

    private static Set<CellRangeAddress> getMergedAddress(Sheet sheet, CellRangeAddress rangeAddress) {
        HashSet<CellRangeAddress> targetCellSet = new HashSet<CellRangeAddress>();
        int fromSheetMargNums = sheet.getNumMergedRegions();
        for (int i = 0; i < fromSheetMargNums; ++i) {
            CellRangeAddress mergedAddress = null;
            if (sheet instanceof XSSFSheet) {
                mergedAddress = ((XSSFSheet)sheet).getMergedRegion(i);
            } else if (sheet instanceof HSSFSheet) {
                mergedAddress = ((HSSFSheet)sheet).getMergedRegion(i);
            }
            if (!PoiUtil.crossRangeAddress(rangeAddress, mergedAddress)) continue;
            if (!PoiUtil.containCellRangeAddress(rangeAddress, mergedAddress)) {
                throw new IllegalArgumentException("There are crossing merged regions in the range.");
            }
            targetCellSet.add(mergedAddress);
        }
        return targetCellSet;
    }

    public static void clearRange(Sheet sheet, CellRangeAddress rangeAddress) {
        PoiUtil.clearMergedRegion(sheet, rangeAddress);
        PoiUtil.clearCell(sheet, rangeAddress);
    }

    public static void clearCell(Sheet sheet, CellRangeAddress rangeAddress) {
        int fromRowIndex = rangeAddress.getFirstRow();
        int fromColumnIndex = rangeAddress.getFirstColumn();
        int toRowIndex = rangeAddress.getLastRow();
        int toColumnIndex = rangeAddress.getLastColumn();
        HashSet<Row> removeRowSet = new HashSet<Row>();
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (fromRowIndex <= row.getRowNum() && row.getRowNum() <= toRowIndex) {
                HashSet<Cell> removeCellSet = new HashSet<Cell>();
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    if (fromColumnIndex > cell.getColumnIndex() || cell.getColumnIndex() > toColumnIndex) continue;
                    removeCellSet.add(cell);
                }
                for (Cell cell : removeCellSet) {
                    row.removeCell(cell);
                }
            }
            if (row.getLastCellNum() != -1) continue;
            removeRowSet.add(row);
        }
        for (Row row : removeRowSet) {
            sheet.removeRow(row);
        }
    }

    public static void clearMergedRegion(Sheet sheet, CellRangeAddress rangeAddress) {
        Set<CellRangeAddress> clearMergedCellSet = PoiUtil.getMergedAddress(sheet, rangeAddress);
        TreeSet deleteIndexs = new TreeSet(Collections.reverseOrder());
        int fromSheetMargNums = sheet.getNumMergedRegions();
        block0: for (int i = 0; i < fromSheetMargNums; ++i) {
            CellRangeAddress mergedAddress = null;
            if (sheet instanceof XSSFSheet) {
                mergedAddress = ((XSSFSheet)sheet).getMergedRegion(i);
            } else if (sheet instanceof HSSFSheet) {
                mergedAddress = ((HSSFSheet)sheet).getMergedRegion(i);
            }
            for (CellRangeAddress address : clearMergedCellSet) {
                if (!mergedAddress.formatAsString().equals(address.formatAsString())) continue;
                deleteIndexs.add(i);
                continue block0;
            }
        }
        for (Integer index : deleteIndexs) {
            sheet.removeMergedRegion(index.intValue());
        }
    }

    public static void prepareCloneSheet(Sheet sheet) {
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                if (cell.getCellType() != 3) continue;
                cell.setCellValue("");
            }
        }
    }

    public static boolean crossRangeAddress(CellRangeAddress baseAddress, CellRangeAddress targetAddress) {
        return baseAddress.getFirstRow() <= targetAddress.getLastRow() && baseAddress.getLastRow() >= targetAddress.getFirstRow() && baseAddress.getFirstColumn() <= targetAddress.getFirstColumn() && baseAddress.getLastColumn() >= targetAddress.getFirstColumn();
    }

    public static boolean containCellRangeAddress(CellRangeAddress baseAddress, CellRangeAddress targetAddress) {
        return baseAddress.getFirstRow() <= targetAddress.getFirstRow() && baseAddress.getLastRow() >= targetAddress.getLastRow() && baseAddress.getFirstColumn() <= targetAddress.getFirstColumn() && baseAddress.getLastColumn() >= targetAddress.getLastColumn();
    }

    public static void setHyperlink(Cell cell, int type, String address) {
        Workbook wb = cell.getRow().getSheet().getWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        Hyperlink link = createHelper.createHyperlink(type);
        if (link instanceof HSSFHyperlink) {
            ((HSSFHyperlink)link).setTextMark(address);
        } else if (link instanceof XSSFHyperlink) {
            ((XSSFHyperlink)link).setAddress(address);
        }
        cell.setHyperlink(link);
    }

    public static void setCellValue(Cell cell, Object value) {
        CellStyle style = cell.getCellStyle();
        if (value != null) {
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Number) {
                Number numValue = (Number)value;
                if (numValue instanceof Float) {
                    Float floatValue = (Float)numValue;
                    numValue = new Double(String.valueOf(floatValue));
                }
                cell.setCellValue(numValue.doubleValue());
            } else if (value instanceof Date) {
                Date dateValue = (Date)value;
                cell.setCellValue(dateValue);
            } else if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                cell.setCellValue(boolValue.booleanValue());
            }
        } else {
            cell.setCellType(3);
            cell.setCellStyle(style);
        }
    }

    public static int getLastColNum(Sheet sheet) {
        short lastColNum = 0;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            short tmpColNum;
            if (sheet.getRow(i) == null || lastColNum >= (tmpColNum = sheet.getRow(i).getLastCellNum())) continue;
            lastColNum = tmpColNum;
        }
        return lastColNum - 1;
    }
}

