/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.POILogger;

public class SystemOutLogger
extends POILogger {
    private String _cat;

    public void initialize(String cat) {
        this._cat = cat;
    }

    public void log(int level, Object obj1) {
        this.log(level, obj1, null);
    }

    public void log(int level, Object obj1, Throwable exception) {
        if (this.check(level)) {
            System.out.println("[" + this._cat + "] " + obj1);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public boolean check(int level) {
        int currentLevel;
        try {
            currentLevel = Integer.parseInt(System.getProperty("poi.log.level", WARN + ""));
        }
        catch (SecurityException e) {
            currentLevel = POILogger.DEBUG;
        }
        return level >= currentLevel;
    }
}

