/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: RecreateSequenceParser.java 64 2009-11-19 02:12:45Z akira-yokoi $
 * $Revision: 64 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.excel2java.ArraysParser;

/**
 * V[g͂AV[PXĐSQL̕<BR>
 * List&lt;String&gt;ŕԋpp[T
 * 
 * @since 1.0
 */
public class RecreateSequenceParser extends SqlParser {

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "@RecreateSequence";

    /**
     * SQL dropړ
     */
    protected static final String SQL_DROP_PREFIX = "drop sequence ";

    /**
     * SQL createړ
     */
    protected static final String SQL_CREATE_PREFIX = "create sequence ";

    /**
     * SQL start
     */
    protected static final String SQL_START = " start with ";

    /**
     * SQLڔ
     */
    protected static final String SQL_SUFFIX = ";";

    /**
     * RXgN^
     */
    public RecreateSequenceParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public RecreateSequenceParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR>
     * nꍇTagParser.parse\bh܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<String> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        List<String> resultList = new ArrayList<String>();

        ArraysParser arraysParser = new ArraysParser( super.getTag());
        List<Object[]> objList = arraysParser.parse( sheet, tagCell, data);

        for ( Object[] obj : objList) {

            try {
                if ( obj.length != 2) {
                    throw new ParseException( tagCell, "V[PXƏݒ肵Ă");
                }
                // V[PXEl̎擾
                Object nameObj = obj[0];
                Object valueObj = obj[1];

                // null`FbN
                if ( nameObj == null) {
                    throw new ParseException( tagCell, "V[PXnullł");
                }
                if ( valueObj == null) {
                    throw new ParseException( tagCell, "lnullł");
                }

                String name = nameObj.toString();
                Double valueDouble = Double.parseDouble( valueObj.toString());
                Integer value = valueDouble.intValue();

                // SQL𐶐AʃXgɒǉ
                resultList.add( createSql( name, value));

            } catch ( Exception e) {
                if ( e instanceof ParseException) {
                    throw ( ParseException) e;
                } else {
                    throw new ParseException( tagCell, e.toString());
                }
            }
        }
        return resultList;
    }

    /**
     * V[PXĐSQL쐬Aԋp
     * 
     * @param name V[PX
     * @param value ݒl
     * @return SQL
     */
    private String createSql( String name, Integer value) {

        StringBuilder strBuild = new StringBuilder();
        strBuild.append( SQL_DROP_PREFIX);
        strBuild.append( name);
        strBuild.append( SQL_SUFFIX);
        strBuild.append( "\n");
        strBuild.append( SQL_CREATE_PREFIX);
        strBuild.append( name);
        strBuild.append( SQL_START);
        strBuild.append( value);
        strBuild.append( SQL_SUFFIX);

        return strBuild.toString();
    }
}
