/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: DefaultSheetToSqlDataConverter.java 40 2009-11-12 04:51:10Z akira-yokoi $
 * $Revision: 40 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql.converter;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlSettingInfo;

/**
 * ftHgŎgpf[^Ro[^B<BR>
 * PostgreSQL 8.3.7̃f[^^ɑΉB<BR>
 * 
 * @since 1.0
 */
public class DefaultSheetToSqlDataConverter implements SheetToSqlDataConverter {

    /**
     * f[^^F<BR>
     * ΏۂƂf[^^F<BR>
     * bit[(n)], bit varying[(n)], box, bytea, character varying[(n)],<BR>
     * character[(n)], cidr, circle, inet, interval[(p)], line, lseg,<BR>
     * macaddr, money, path, point, polygon, text, tsquery, tsvector,<BR>
     * txid_snapshot, uuid, xml<BR>
     */
    public static final String DATA_TYPE_STRING = "";

    /**
     * f[^^Fl ΏۂƂf[^^F<BR>
     * bigint, bigserial, integer, smallint, serial, uuid, xml<BR>
     */
    public static final String DATA_TYPE_NUMERIC = "l";

    /**
     * f[^^F ΏۂƂf[^^F<BR>
     * double precision, numeric[(p,s)], real<BR>
     */
    public static final String DATA_TYPE_INTEGER = "";

    /**
     * f[^^F_l ΏۂƂf[^^F<BR>
     * boolean<BR>
     */
    public static final String DATA_TYPE_BOOLEAN = "_l";

    /**
     * f[^^Ft ΏۂƂf[^^F<BR>
     * date<BR>
     */
    public static final String DATA_TYPE_DATE = "t";

    /**
     * f[^^F ΏۂƂf[^^F<BR>
     * time[(p)] [without time zone], time[(p)] with time zone<BR>
     */
    public static final String DATA_TYPE_TIME = "";

    /**
     * f[^^F^CX^v ΏۂƂf[^^F<BR>
     * timestamp[(p)] [without time zone], timestamp[(p)] with time zone<BR>
     */
    public static final String DATA_TYPE_TIMESTAMP = "^CX^v";

    /**
     * f[^^F֐ ΏۂƂf[^^F<BR>
     * SQL֐<BR>
     */
    public static final String DATA_TYPE_FUNCTION = "֐";

    /**
     * VONI[e[V
     */
    private static final String SINGLE_QUOTE = "'";

    /**
     * t؂蕶
     */
    private static final String DATE_SEPARATOR = "-";

    /**
     * ԋ؂蕶
     */
    private static final String TIME_SEPARATOR = ":";

    /**
     * sIh
     */
    private static final String PERIOD = ".";

    /**
     * f[^^ɊÂARo[gs<BR>
     * IuWFNgnull̏ꍇnullԋpB<BR>
     * f[^^null̏ꍇ̓VONI[e[Vt^ԋpB<BR>
     * 
     * @param object IuWFNg
     * @param dataType f[^^
     * @param settingInfo SQLϊݒ
     * @return Ro[gꂽ
     * @throws ParseException IuWFNgϊɗOꍇ<BR>
     *                         ݂Ȃf[^^w肳ꂽꍇ<BR>
     */
    public String convert( Object object, String dataType, SheetToSqlSettingInfo settingInfo) throws ParseException {

        String result = null;

        if ( object == null) {
            // IuWFNgnull̏ꍇ
            return null;
        }

        if ( dataType == null || DATA_TYPE_STRING.equals( dataType)) {
            // f[^^null ܂ ̏ꍇ

            // VONI[e[Vt
            String value = object.toString();
            result = getSingleQuotedString( value);

        } else if ( DATA_TYPE_NUMERIC.equals( dataType)) {
            // f[^^l̏ꍇ

            try {
                Double value = Double.parseDouble( object.toString());
                result = value.toString();
            } catch ( Exception e) {
                throw new ParseException( settingInfo.getValueCell(), "llł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_INTEGER.equals( dataType)) {
            // f[^^̏ꍇ

            try {
                Double value = Double.parseDouble( object.toString());
                Integer valueInt = value.intValue();
                result = valueInt.toString();
            } catch ( Exception e) {
                throw new ParseException( settingInfo.getValueCell(), "lł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_BOOLEAN.equals( dataType)) {
            // f[^^_l̏ꍇ

            String value = object.toString();
            if ( isTrueExpression( value)) {
                result = "TRUE";
            } else if ( isFalseExpression( value)) {
                result = "FALSE";
            } else {
                throw new ParseException( settingInfo.getValueCell(), "l_lł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_DATE.equals( dataType)) {
            // f[^^t̏ꍇ

            try {
                Date date = ( Date) object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime( date);
                String ymd = getYmdString( gCal);
                result = getSingleQuotedString( ymd);
            } catch ( Exception e) {
                throw new ParseException( settingInfo.getValueCell(), "ltł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_TIME.equals( dataType)) {
            // f[^^Ԃ̏ꍇ

            try {
                Date date = ( Date) object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime( date);
                String time = getTimeString( gCal);
                result = getSingleQuotedString( time);
            } catch ( Exception e) {
                throw new ParseException( settingInfo.getValueCell(), "lԂł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_TIMESTAMP.equals( dataType)) {
            // f[^^^CX^v̏ꍇ

            try {
                Date date = ( Date) object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime( date);
                String timestamp = getTimestampString( gCal);
                result = getSingleQuotedString( timestamp);
            } catch ( Exception e) {
                throw new ParseException( settingInfo.getValueCell(), "l^CX^vł͂܂F" + object.toString());
            }

        } else if ( DATA_TYPE_FUNCTION.equals( dataType)) {
            // f[^^֐̏ꍇ

            // VONI[e[VtȂ
            result = object.toString();

        } else {
            // YȂꍇ
            throw new ParseException( settingInfo.getDataTypeCell(), "f[^^sF" + dataType);
        }

        return result;
    }

    /**
     * YYYY-MM-DD hh:mm:ss.mmm^̕ɕϊAԋp
     * 
     * @param gCal OSAJ_[
     * @return ^CX^v
     */
    private String getTimestampString( GregorianCalendar gCal) {

        StringBuilder strBuild = new StringBuilder();

        strBuild.append( getYmdString( gCal));
        strBuild.append( " ");
        strBuild.append( getTimeString( gCal));

        return strBuild.toString();
    }

    /**
     * hh:mm:ss.mmm^̕ɕϊAԋp
     * 
     * @param gCal OSAJ_[
     * @return hh:mm:ss.mmm^̕
     */
    private String getTimeString( GregorianCalendar gCal) {

        StringBuilder strBuild = new StringBuilder();
        strBuild.append( getTwoDigitString( gCal.get( Calendar.HOUR_OF_DAY)));
        strBuild.append( TIME_SEPARATOR);
        strBuild.append( getTwoDigitString( gCal.get( Calendar.MINUTE)));
        strBuild.append( TIME_SEPARATOR);
        strBuild.append( getTwoDigitString( gCal.get( Calendar.SECOND)));
        strBuild.append( PERIOD);
        strBuild.append( gCal.get( Calendar.MILLISECOND));

        return strBuild.toString();
    }

    /**
     * YYYY-MM-DD^̕ɕϊAԋp
     * 
     * @param gCal OSAJ_[
     * @return YYYY-MM-DD^̕
     */
    private String getYmdString( GregorianCalendar gCal) {

        StringBuilder strBuild = new StringBuilder();
        strBuild.append( gCal.get( Calendar.YEAR));
        strBuild.append( DATE_SEPARATOR);
        strBuild.append( getTwoDigitString( gCal.get( Calendar.MONTH) + 1));
        strBuild.append( DATE_SEPARATOR);
        strBuild.append( getTwoDigitString( gCal.get( Calendar.DATE)));

        return strBuild.toString();
    }

    /**
     * ɃVONI[e[Vt^Aԋp
     * 
     * @param string 
     * @return VONI[e[Vt^
     */
    private String getSingleQuotedString( String string) {

        StringBuilder strBuild = new StringBuilder();
        strBuild.append( SINGLE_QUOTE).append( string).append( SINGLE_QUOTE);
        return strBuild.toString();
    }

    /**
     * Boolean^SQLTRUE\<BR>
     * ǂ𔻒肵AʂԂ<BR>
     * 
     * @param string 
     * @return TRUE\̏ꍇtrueAȊȌꍇfalse
     */
    private boolean isTrueExpression( String string) {

        boolean result = false;

        List<String> trueStrings = new ArrayList<String>();
        trueStrings.add( "true");
        trueStrings.add( "TRUE");
        trueStrings.add( "t");
        trueStrings.add( "T");
        trueStrings.add( "y");
        trueStrings.add( "Y");
        trueStrings.add( "yes");
        trueStrings.add( "YES");
        trueStrings.add( "1");

        if ( trueStrings.contains( string)) {
            result = true;
        }
        return result;
    }

    /**
     * Boolean^SQLFALSE\<BR>
     * ǂ𔻒肵AʂԂ<BR>
     * 
     * @param string 
     * @return FALSE\̏ꍇtrueAȊȌꍇfalse
     */
    private boolean isFalseExpression( String string) {

        boolean result = false;

        List<String> falseStrings = new ArrayList<String>();
        falseStrings.add( "false");
        falseStrings.add( "FALSE");
        falseStrings.add( "f");
        falseStrings.add( "F");
        falseStrings.add( "n");
        falseStrings.add( "N");
        falseStrings.add( "no");
        falseStrings.add( "NO");
        falseStrings.add( "0");

        if ( falseStrings.contains( string)) {
            result = true;
        }
        return result;
    }

    /**
     * l񌅂̕ɕϊAԋpB<BR>
     * lꌅ̏ꍇ̓[߂sB<BR>
     * 
     * @param num
     * @return 񌅂̐l
     */
    private String getTwoDigitString( int num) {

        DecimalFormat decimalFormat = new DecimalFormat( "00");
        return decimalFormat.format( num);
    }
}
