/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: ConnectivityTest.java 2 2009-06-22 04:48:53Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.processor;

import static org.junit.Assert.assertEquals;

import java.text.DateFormat;
import java.util.List;

import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.trans.WorkbookTest;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaExecuter;
import org.bbreak.excella.trans.tag.sheet2java.TestChildEntityParser;
import org.bbreak.excella.trans.tag.sheet2java.entity.TestEntity1;
import org.bbreak.excella.trans.tag.sheet2java.entity.TestEntity2;
import org.bbreak.excella.trans.tag.sheet2sql.SheetToSqlExecuter;
import org.bbreak.excella.trans.tag.sheet2sql.converter.DefaultSheetToSqlDataConverter;
import org.junit.Test;

/**
 * SheetToJavaASheetToSql̑aʃeXgNX<BR>
 * 
 * SheetToSqlParser, SheetToSqlSettingParser, SheetToSqlExecuter<BR>
 * SheetToJavaParser, SheetToJavaSettingParser, SheetToJavaExecuteȑ<BR>
 * s邩eXg<BR>
 * 
 * @since 1.0
 */
public class ConnectivityTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public ConnectivityTest( String version) {
        super( version);
    }

    @Test
    @SuppressWarnings( "unchecked")
    public final void testConnectivity() throws Exception {

        super.getWorkbook();
        String filePath = super.getFilepath();
        TransProcessor processor = new TransProcessor( filePath);

        // ftHgV[gXi폜
        processor.clearSheetParseListeners();

        // SheetToJavãV[gXiǉ
        SheetToJavaExecuter javaExecuter = new SheetToJavaExecuter();
        javaExecuter.addPropertyParser( new TestChildEntityParser());
        processor.addSheetParseListener( javaExecuter);

        // SheetToSql̃V[gXiǉ
        SheetToSqlExecuter sqlExecuter = new SheetToSqlExecuter();
        sqlExecuter.setDataConverter( new DefaultSheetToSqlDataConverter());
        processor.addSheetParseListener( sqlExecuter);

        // vZXs
        BookData bookData = processor.processBook();

        // ľ؁FSheetToJava
        SheetData sheetData = bookData.getSheetData( "Connectivity");
        List<Object> javaResults = ( List<Object>) sheetData.get( "@SheetToJava");
        assertEquals( 9, javaResults.size());
        assertEquals( "1", (( TestEntity1) javaResults.get( 0)).getPropertyStr1());
        assertEquals( "2", (( TestEntity1) javaResults.get( 1)).getPropertyStr1());
        assertEquals( "3", (( TestEntity1) javaResults.get( 2)).getPropertyStr1());
        assertEquals( "4", (( TestEntity1) javaResults.get( 3)).getPropertyStr1());
        assertEquals( "1", (( TestEntity2) javaResults.get( 4)).getPropertyStr2());
        assertEquals( "1", (( TestEntity2) javaResults.get( 5)).getPropertyStr2());
        assertEquals( "2", (( TestEntity2) javaResults.get( 6)).getPropertyStr2());
        assertEquals( "3", (( TestEntity2) javaResults.get( 7)).getPropertyStr2());
        assertEquals( "4", (( TestEntity2) javaResults.get( 8)).getPropertyStr2());
        assertEquals( new Integer( 10), (( TestEntity1) javaResults.get( 0)).getPropertyInt1());
        assertEquals( new Integer( 20), (( TestEntity1) javaResults.get( 1)).getPropertyInt1());
        assertEquals( new Integer( 30), (( TestEntity1) javaResults.get( 2)).getPropertyInt1());
        assertEquals( new Integer( 40), (( TestEntity1) javaResults.get( 3)).getPropertyInt1());
        assertEquals( new Integer( 10), (( TestEntity2) javaResults.get( 4)).getPropertyInt2());
        assertEquals( new Integer( 10), (( TestEntity2) javaResults.get( 5)).getPropertyInt2());
        assertEquals( new Integer( 10), (( TestEntity2) javaResults.get( 6)).getPropertyInt2());
        assertEquals( new Integer( 10), (( TestEntity2) javaResults.get( 7)).getPropertyInt2());
        assertEquals( new Integer( 10), (( TestEntity2) javaResults.get( 8)).getPropertyInt2());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/08"), (( TestEntity1) javaResults.get( 0)).getPropertyDate1());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/08"), (( TestEntity1) javaResults.get( 1)).getPropertyDate1());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/08"), (( TestEntity1) javaResults.get( 2)).getPropertyDate1());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/08"), (( TestEntity1) javaResults.get( 3)).getPropertyDate1());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/01"), (( TestEntity2) javaResults.get( 4)).getPropertyDate2());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/02"), (( TestEntity2) javaResults.get( 5)).getPropertyDate2());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/03"), (( TestEntity2) javaResults.get( 6)).getPropertyDate2());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/04"), (( TestEntity2) javaResults.get( 7)).getPropertyDate2());
        assertEquals( DateFormat.getDateInstance().parse( "2009/06/05"), (( TestEntity2) javaResults.get( 8)).getPropertyDate2());
        assertEquals( "1", (( TestEntity1) javaResults.get( 0)).getChild().getChildPropertyStr1());
        assertEquals( "2", (( TestEntity1) javaResults.get( 1)).getChild().getChildPropertyStr1());
        assertEquals( "3", (( TestEntity1) javaResults.get( 2)).getChild().getChildPropertyStr1());
        assertEquals( "4", (( TestEntity1) javaResults.get( 3)).getChild().getChildPropertyStr1());
        assertEquals( new Integer( 10), (( TestEntity1) javaResults.get( 0)).getChild().getChildPropertyInt1());
        assertEquals( new Integer( 20), (( TestEntity1) javaResults.get( 1)).getChild().getChildPropertyInt1());
        assertEquals( new Integer( 30), (( TestEntity1) javaResults.get( 2)).getChild().getChildPropertyInt1());
        assertEquals( new Integer( 40), (( TestEntity1) javaResults.get( 3)).getChild().getChildPropertyInt1());

        // ľ؁FSheetToSql
        sheetData = bookData.getSheetData( "Connectivity 2");
        List<String> sqlResults = ( List<String>) sheetData.get( "@SheetToSql");
        assertEquals( 9, sqlResults.size());
        String sql1 = "insert into test_table1 (column_name1,column_name2,column_name3,column_name4) values ('1',100.0,10,FALSE);";
        String sql2 = "insert into test_table1 (column_name1,column_name2,column_name3,column_name4) values ('2',100.0,20,FALSE);";
        String sql3 = "insert into test_table1 (column_name1,column_name2,column_name3,column_name4) values ('3',100.0,30,FALSE);";
        String sql4 = "insert into test_table1 (column_name1,column_name2,column_name3,column_name4) values ('4',100.0,40,FALSE);";
        String sql5 = "insert into test_table2 (column_name1,column_name2,column_name3,column_name4,column_name5,column_name6,column_name7,column_name8) values ('1',3.14,200,TRUE,'2009-06-01','12:13:14.0','2009-06-08 12:13:14.0',CURRENT_TIMESTAMP);";
        String sql6 = "insert into test_table2 (column_name1,column_name2,column_name3,column_name4,column_name5,column_name6,column_name7,column_name8) values ('1',3.14,200,TRUE,'2009-06-02','12:13:14.0','2009-06-08 12:13:14.0',CURRENT_TIMESTAMP);";
        String sql7 = "insert into test_table2 (column_name1,column_name2,column_name3,column_name4,column_name5,column_name6,column_name7,column_name8) values ('2',3.14,200,TRUE,'2009-06-03','12:13:14.0','2009-06-08 12:13:14.0',CURRENT_TIMESTAMP);";
        String sql8 = "insert into test_table2 (column_name1,column_name2,column_name3,column_name4,column_name5,column_name6,column_name7,column_name8) values ('3',3.14,200,TRUE,'2009-06-04','12:13:14.0','2009-06-08 12:13:14.0',CURRENT_TIMESTAMP);";
        String sql9 = "insert into test_table2 (column_name1,column_name2,column_name3,column_name4,column_name5,column_name6,column_name7,column_name8) values ('4',3.14,200,TRUE,'2009-06-05','12:13:14.0','2009-06-08 12:13:14.0',CURRENT_TIMESTAMP);";
        assertEquals( sql1, sqlResults.get( 0));
        assertEquals( sql2, sqlResults.get( 1));
        assertEquals( sql3, sqlResults.get( 2));
        assertEquals( sql4, sqlResults.get( 3));
        assertEquals( sql5, sqlResults.get( 4));
        assertEquals( sql6, sqlResults.get( 5));
        assertEquals( sql7, sqlResults.get( 6));
        assertEquals( sql8, sqlResults.get( 7));
        assertEquals( sql9, sqlResults.get( 8));

    }
}
