/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAnnotationGenerator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogClient
extends SVNBasicClient {
    private SVNDiffOptions myDiffOptions;

    public SVNLogClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNLogClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        this.myDiffOptions = diffOptions;
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        this.doAnnotate(path, pegRevision, startRevision, endRevision, false, false, handler, null);
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, ISVNAnnotateHandler handler) throws SVNException {
        this.doAnnotate(path, pegRevision, startRevision, endRevision, ignoreMimeType, false, handler, null);
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, boolean includeMergedRevisions, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        long startRev;
        SVNRepository repos;
        long endRev;
        if (startRevision == null || !startRevision.isValid()) {
            startRevision = SVNRevision.create(1L);
        }
        if (endRevision == null || !endRevision.isValid()) {
            endRevision = pegRevision;
        }
        if (startRevision == SVNRevision.WORKING || endRevision == SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Blame of the WORKING revision is not supported");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((endRev = this.getRevisionNumber(endRevision, repos = this.createRepository(null, path, null, pegRevision, endRevision, null), path)) < (startRev = this.getRevisionNumber(startRevision, repos, path))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"), SVNLogType.DEFAULT);
        }
        File tmpFile = new File(path.getParentFile(), SVNFileUtil.getAdminDirectoryName());
        if (!(tmpFile = new File(tmpFile, "tmp/text-base")).isDirectory()) {
            tmpFile = SVNFileUtil.createTempDirectory("annotate");
        }
        this.doAnnotate(path.getAbsolutePath(), startRev, tmpFile, repos, endRev, ignoreMimeType, handler, inputEncoding, includeMergedRevisions);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        this.doAnnotate(url, pegRevision, startRevision, endRevision, false, false, handler, null);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        this.doAnnotate(url, pegRevision, startRevision, endRevision, false, false, handler, inputEncoding);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        this.doAnnotate(url, pegRevision, startRevision, endRevision, ignoreMimeType, false, handler, inputEncoding);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, boolean includeMergedRevisions, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        long startRev;
        SVNRepository repos;
        long endRev;
        if (startRevision == null || !startRevision.isValid()) {
            startRevision = SVNRevision.create(1L);
        }
        if (endRevision == null || !endRevision.isValid()) {
            endRevision = pegRevision;
        }
        if (startRevision == SVNRevision.WORKING || endRevision == SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Blame of the WORKING revision is not supported");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((endRev = this.getRevisionNumber(endRevision, repos = this.createRepository(url, null, null, pegRevision, endRevision, null), null)) < (startRev = this.getRevisionNumber(startRevision, repos, null))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"), SVNLogType.DEFAULT);
        }
        File tmpFile = SVNFileUtil.createTempDirectory("annotate");
        this.doAnnotate(repos.getLocation().toDecodedString(), startRev, tmpFile, repos, endRev, ignoreMimeType, handler, inputEncoding, includeMergedRevisions);
    }

    public void doLog(File[] paths, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        this.doLog(paths, startRevision, endRevision, SVNRevision.UNDEFINED, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(File[] paths, SVNRevision startRevision, SVNRevision endRevision, SVNRevision pegRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        int i;
        SVNErrorMessage err;
        if (paths == null || paths.length == 0 || handler == null) {
            return;
        }
        if (startRevision.isValid() && !endRevision.isValid()) {
            endRevision = startRevision;
        } else if (!startRevision.isValid()) {
            startRevision = !pegRevision.isValid() ? SVNRevision.BASE : pegRevision;
            if (!endRevision.isValid()) {
                endRevision = SVNRevision.create(0L);
            }
        }
        if (limit > Integer.MAX_VALUE) {
            limit = Integer.MAX_VALUE;
        }
        ISVNLogEntryHandler wrappingHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                SVNLogClient.this.checkCancelled();
                handler.handleLogEntry(logEntry);
            }
        };
        SVNURL[] urls = new SVNURL[paths.length];
        SVNWCAccess wcAccess = this.createWCAccess();
        ArrayList<String> wcPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            this.checkCancelled();
            File path = paths[i2];
            wcPaths.add(path.getAbsolutePath().replace(File.separatorChar, '/'));
            SVNAdminArea area = wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(path, false);
            if (entry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            urls[i2] = entry.getSVNURL();
            if (area == null) continue;
            wcAccess.closeAdminArea(area.getRoot());
        }
        if (urls.length == 0) {
            return;
        }
        String[] wcPathsArray = wcPaths.toArray(new String[wcPaths.size()]);
        String rootWCPath = SVNPathUtil.condencePaths(wcPathsArray, null, true);
        TreeSet<String> targets = new TreeSet<String>();
        SVNURL baseURL = SVNURLUtil.condenceURLs(urls, targets, true);
        if (baseURL == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "target log paths belong to different repositories");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (targets.isEmpty()) {
            targets.add("");
        }
        SVNRevision rev = SVNRevision.UNDEFINED;
        if (startRevision.getNumber() >= 0L && endRevision.getNumber() >= 0L) {
            rev = startRevision.getNumber() > endRevision.getNumber() ? startRevision : endRevision;
        } else if (startRevision.getDate() != null && endRevision.getDate() != null) {
            rev = startRevision.getDate().compareTo(endRevision.getDate()) > 0 ? startRevision : endRevision;
        }
        SVNRepository repos = null;
        if (rootWCPath != null && (pegRevision == SVNRevision.BASE || pegRevision == SVNRevision.WORKING || pegRevision == SVNRevision.PREVIOUS || pegRevision == SVNRevision.COMMITTED)) {
            File root = new File(rootWCPath);
            SVNAdminArea area = wcAccess.probeOpen(root, false, 0);
            repos = this.createRepository(null, root, area, pegRevision, rev, null);
            if (area != null) {
                wcAccess.closeAdminArea(area.getRoot());
            }
        } else {
            repos = this.createRepository(baseURL, null, null, pegRevision, rev, null);
        }
        String[] targetPaths = targets.toArray(new String[targets.size()]);
        for (i = 0; i < targetPaths.length; ++i) {
            targetPaths[i] = SVNEncodingUtil.uriDecode(targetPaths[i]);
        }
        if (startRevision.isLocal() || endRevision.isLocal()) {
            for (i = 0; i < paths.length; ++i) {
                this.checkCancelled();
                long startRev = this.getRevisionNumber(startRevision, repos, paths[i]);
                long endRev = this.getRevisionNumber(endRevision, repos, paths[i]);
                repos.log(targetPaths, startRev, endRev, discoverChangedPaths, stopOnCopy, limit, includeMergedRevisions, revisionProperties, wrappingHandler);
            }
        } else {
            long startRev = this.getRevisionNumber(startRevision, repos, null);
            long endRev = this.getRevisionNumber(endRevision, repos, null);
            repos.log(targetPaths, startRev, endRev, discoverChangedPaths, stopOnCopy, limit, includeMergedRevisions, revisionProperties, wrappingHandler);
        }
    }

    public void doLog(File[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        this.doLog(paths, startRevision, endRevision, pegRevision, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        this.doLog(url, paths, pegRevision, startRevision, endRevision, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        String[] stringArray;
        SVNErrorMessage err;
        if (!startRevision.isValid() || !endRevision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (pegRevision == SVNRevision.BASE || pegRevision == SVNRevision.COMMITTED || pegRevision == SVNRevision.PREVIOUS) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not a URL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (limit > Integer.MAX_VALUE) {
            limit = Integer.MAX_VALUE;
        }
        if (paths == null || paths.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = paths;
        }
        paths = stringArray;
        ISVNLogEntryHandler wrappingHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                SVNLogClient.this.checkCancelled();
                handler.handleLogEntry(logEntry);
            }
        };
        SVNRevision rev = SVNRevision.UNDEFINED;
        if (startRevision.getNumber() >= 0L && endRevision.getNumber() >= 0L) {
            rev = startRevision.getNumber() > endRevision.getNumber() ? startRevision : endRevision;
        } else if (startRevision.getDate() != null && endRevision.getDate() != null) {
            rev = startRevision.getDate().compareTo(endRevision.getDate()) > 0 ? startRevision : endRevision;
        }
        SVNRepository repos = rev.isValid() ? this.createRepository(url, null, null, pegRevision, rev, null) : this.createRepository(url, null, null, true);
        this.checkCancelled();
        long startRev = this.getRevisionNumber(startRevision, repos, null);
        this.checkCancelled();
        long endRev = this.getRevisionNumber(endRevision, repos, null);
        this.checkCancelled();
        repos.log(paths, startRev, endRev, discoverChangedPaths, stopOnCopy, limit, includeMergedRevisions, revisionProperties, wrappingHandler);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(path, pegRevision, revision, fetchLocks, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, SVNDepth depth, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.BASE;
        }
        SVNRepository repos = this.createRepository(null, path, null, pegRevision, revision, null);
        long rev = this.getRevisionNumber(revision, repos, path);
        this.doList(repos, rev, handler, fetchLocks, depth, entryFields);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(path, pegRevision, revision, false, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(url, pegRevision, revision, fetchLocks, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, SVNDepth depth, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        long[] pegRev = new long[]{-1L};
        SVNRepository repos = this.createRepository(url, null, null, pegRevision, revision, pegRev);
        if (pegRev[0] < 0L) {
            pegRev[0] = this.getRevisionNumber(revision, repos, null);
        }
        this.doList(repos, pegRev[0], handler, fetchLocks, depth, entryFields);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(url, pegRevision, revision, false, recursive, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAnnotate(String path, long startRev, File tmpFile, SVNRepository repos, long endRev, boolean ignoreMimeType, ISVNAnnotateHandler handler, String inputEncoding, boolean includeMergedRevisions) throws SVNException {
        SVNAnnotationGenerator generator = new SVNAnnotationGenerator(path, tmpFile, startRev, ignoreMimeType, includeMergedRevisions, this.getDiffOptions(), inputEncoding, handler, this);
        boolean useSpool = handler != null && !handler.getClass().getName().startsWith("org.tmatesoft.svn.");
        boolean oldSpool = false;
        if (useSpool && repos instanceof DAVRepository) {
            oldSpool = ((DAVRepository)repos).isSpoolResponse();
            ((DAVRepository)repos).setSpoolResponse(true);
        }
        try {
            repos.getFileRevisions("", startRev > 0L ? startRev - 1L : startRev, endRev, includeMergedRevisions, generator);
            if (!generator.isLastRevisionReported()) {
                generator.reportAnnotations(handler, inputEncoding);
            }
            Object var16_13 = null;
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            if (useSpool && repos instanceof DAVRepository) {
                ((DAVRepository)repos).setSpoolResponse(oldSpool);
            }
            generator.dispose();
            SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
            throw throwable;
        }
        if (useSpool && repos instanceof DAVRepository) {
            ((DAVRepository)repos).setSpoolResponse(oldSpool);
        }
        generator.dispose();
        SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
    }

    private void doList(SVNRepository repos, long rev, final ISVNDirEntryHandler handler, boolean fetchLocks, SVNDepth depth, int entryFields) throws SVNException {
        SVNURL url = repos.getLocation();
        SVNURL reposRoot = repos.getRepositoryRoot(false);
        SVNDirEntry entry = null;
        SVNException error = null;
        try {
            entry = repos.info("", rev);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                error = svne;
            }
            throw svne;
        }
        if (error != null) {
            SVNNodeKind kind = repos.checkPath("", rev);
            if (kind != SVNNodeKind.NONE) {
                if (!url.equals(reposRoot)) {
                    String name = SVNPathUtil.tail(repos.getLocation().getPath());
                    repos.setLocation(repos.getLocation().removePathTail(), false);
                    Collection dirEntries = repos.getDir("", rev, null, entryFields, (Collection)null);
                    repos.setLocation(url, false);
                    Iterator ents = dirEntries.iterator();
                    while (ents.hasNext()) {
                        SVNDirEntry dirEntry = (SVNDirEntry)ents.next();
                        if (!name.equals(dirEntry.getName())) continue;
                        entry = dirEntry;
                        break;
                    }
                    if (entry != null) {
                        entry.setRelativePath(kind == SVNNodeKind.FILE ? name : "");
                    }
                } else {
                    SVNProperties props = new SVNProperties();
                    repos.getDir("", rev, props, entryFields, (Collection)null);
                    SVNProperties revProps = repos.getRevisionProperties(rev, null);
                    String author = revProps.getStringValue("svn:author");
                    String dateStr = revProps.getStringValue("svn:date");
                    Date datestamp = null;
                    if (dateStr != null) {
                        datestamp = SVNDate.parseDateString(dateStr);
                    }
                    entry = new SVNDirEntry(url, reposRoot, "", kind, 0L, !props.isEmpty(), rev, datestamp, author);
                    entry.setRelativePath("");
                }
            }
        } else if (entry != null) {
            entry.setRelativePath(entry.getKind() == SVNNodeKind.DIR ? "" : entry.getName());
        }
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' non-existent in that revision", url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        final SVNHashMap locksMap = new SVNHashMap();
        if (fetchLocks) {
            SVNLock[] locks;
            block19: {
                locks = new SVNLock[]{};
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) break block19;
                    throw e;
                }
            }
            if (locks != null && locks.length > 0) {
                SVNURL root = repos.getRepositoryRoot(true);
                for (int i = 0; i < locks.length; ++i) {
                    String repositoryPath = locks[i].getPath();
                    locksMap.put(root.appendPath(repositoryPath, false), locks[i]);
                }
            }
        }
        ISVNDirEntryHandler nestedHandler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                dirEntry.setLock((SVNLock)locksMap.get(dirEntry.getURL()));
                handler.handleDirEntry(dirEntry);
            }
        };
        nestedHandler.handleDirEntry(entry);
        if (entry.getKind() == SVNNodeKind.DIR && (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY)) {
            SVNLogClient.list(repos, "", rev, depth, entryFields, nestedHandler);
        }
    }

    private static void list(SVNRepository repository, String path, long rev, SVNDepth depth, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        Collection entries = new TreeSet();
        entries = repository.getDir(path, rev, null, entryFields, entries);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            SVNDirEntry entry = (SVNDirEntry)iterator.next();
            String childPath = SVNPathUtil.append(path, entry.getName());
            entry.setRelativePath(childPath);
            if (entry.getKind() == SVNNodeKind.FILE || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY) {
                handler.handleDirEntry(entry);
            }
            if (entry.getKind() != SVNNodeKind.DIR || entry.getDate() == null || depth != SVNDepth.INFINITY) continue;
            SVNLogClient.list(repository, childPath, rev, depth, entryFields, handler);
        }
    }
}

