/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Copy
extends SvnCommand {
    private File srcPath = null;
    private File destPath = null;
    private SVNUrl srcUrl = null;
    private SVNUrl destUrl = null;
    private SVNRevision revision = SVNRevision.HEAD;
    private String message = null;

    public void execute() throws SvnAntException {
        try {
            if (this.srcPath != null) {
                if (this.destPath != null) {
                    this.svnClient.copy(this.srcPath, this.destPath);
                } else {
                    this.svnClient.copy(this.srcPath, this.destUrl, this.message);
                }
            } else if (this.destPath != null) {
                this.svnClient.copy(this.srcUrl, this.destPath, this.revision);
            } else {
                this.svnClient.copy(this.srcUrl, this.destUrl, this.message, this.revision);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't copy", sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.srcPath == null && this.srcUrl == null || this.srcPath != null && this.srcUrl != null) {
            throw new SvnAntValidationException("srcPath attribute or srcUrl attribute must be set");
        }
        if (this.destPath == null && this.destUrl == null || this.destPath != null && this.destUrl != null) {
            throw new SvnAntValidationException("destPath attribute or destUrl attribute must be set");
        }
        if (this.destUrl != null && this.message == null) {
            throw new SvnAntValidationException("message attribute needed when destUrl is set");
        }
        if (this.destUrl == null && this.message != null) {
            throw new SvnAntValidationException("message attribute cannot be used when destUrl is not set");
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setDestUrl(SVNUrl sVNUrl) {
        this.destUrl = sVNUrl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }
}

