/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.IOException;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Propset
extends SvnCommand {
    private File path = null;
    private File file;
    private String propName = null;
    private String propValue = null;
    private boolean recurse = false;

    public void execute() throws SvnAntException {
        try {
            if (this.propValue != null) {
                this.svnClient.propertySet(this.path, this.propName, this.propValue, this.recurse);
            } else {
                this.svnClient.propertySet(this.path, this.propName, this.file, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't set property " + this.propName, sVNClientException);
        }
        catch (IOException iOException) {
            throw new SvnAntException("Can't set property " + this.propName, iOException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.path == null) {
            throw new SvnAntValidationException("path attribute must be set");
        }
        if (this.propName == null) {
            throw new SvnAntValidationException("name attribute must be set");
        }
        if (this.propValue == null && this.file == null) {
            throw new SvnAntValidationException("value or file attribute must be set");
        }
        if (this.propValue != null && this.file != null) {
            throw new SvnAntValidationException("file attribute must not be set when value attribute is set");
        }
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setName(String string) {
        this.propName = string;
    }

    public void setValue(String string) {
        this.propValue = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

