/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;

public class SheetToJavaParser
extends TagParser<List<SheetToJavaParseInfo>> {
    public static final String DEFAULT_TAG = "@SheetToJava";
    protected static final String PARAM_SETTING_TAG_NAME = "SettingTagName";
    protected static final String DEFAULT_SETTING_SUFFIX = "Setting";
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final String PARAM_RESULT_KEY = "ResultKey";
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;

    public SheetToJavaParser() {
        super(DEFAULT_TAG);
    }

    public SheetToJavaParser(String tag) {
        super(tag);
    }

    public List<SheetToJavaParseInfo> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        String settingTagName = this.getTag() + DEFAULT_SETTING_SUFFIX;
        try {
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_FROM, (int)2);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom");
            }
            if ((valueRowToIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_TO, (int)(valueRowToIdx - tagRowIdx))) > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowTo");
            }
            if (valueRowFromIdx > valueRowToIdx) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom,DataRowTo");
            }
            if (paramDef.containsKey(PARAM_SETTING_TAG_NAME)) {
                settingTagName = (String)paramDef.get(PARAM_SETTING_TAG_NAME);
            }
            if (paramDef.containsKey(PARAM_RESULT_KEY)) {
                throw new ParseException(tagCell, "ResultKey\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044\u30d1\u30e9\u30e1\u30fc\u30bf\u3067\u3059");
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)((Object)e);
            }
            throw new ParseException(tagCell, (Throwable)e);
        }
        ArrayList<SheetToJavaParseInfo> sheetInfoList = new ArrayList<SheetToJavaParseInfo>();
        int sheetNameColIdx = tagColIdx++;
        int logicalRowColIdx = tagColIdx++;
        int dataRowColIdx = tagColIdx;
        Workbook workbook = sheet.getWorkbook();
        for (int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; ++rowNum) {
            int valueRowNum;
            int logicalRowNum;
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            Cell sheetNameCell = row.getCell(sheetNameColIdx);
            Cell logicalRowNumCell = row.getCell(logicalRowColIdx);
            Cell valueRowNumCell = row.getCell(dataRowColIdx);
            if (sheetNameCell == null && logicalRowNumCell == null && valueRowNumCell == null || sheetNameCell == null || sheetNameCell.getStringCellValue() == null || "".equals(sheetNameCell.getStringCellValue())) continue;
            Cell requiredErrorCell = null;
            if (logicalRowNumCell == null) {
                requiredErrorCell = row.createCell(logicalRowColIdx);
            } else if (valueRowNumCell == null) {
                requiredErrorCell = row.createCell(dataRowColIdx);
            }
            if (requiredErrorCell != null) {
                throw new ParseException(requiredErrorCell, "\u5fc5\u9808\u30bb\u30eb\u304cnull\u3067\u3059");
            }
            try {
                logicalRowNum = (Integer)PoiUtil.getCellValue((Cell)logicalRowNumCell, Integer.class);
            }
            catch (Exception e) {
                throw new ParseException(logicalRowNumCell, (Throwable)e);
            }
            try {
                valueRowNum = (Integer)PoiUtil.getCellValue((Cell)valueRowNumCell, Integer.class);
            }
            catch (Exception e) {
                throw new ParseException(valueRowNumCell, (Throwable)e);
            }
            String sheetName = sheetNameCell.getStringCellValue();
            if (workbook.getSheet(sheetName) == null) {
                throw new ParseException(sheetNameCell, "\u30b7\u30fc\u30c8[" + sheetName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            SheetToJavaParseInfo sheetInfo = new SheetToJavaParseInfo();
            sheetInfo.setSettingTagName(settingTagName);
            sheetInfo.setSettingTagNameCell(tagCell);
            sheetInfo.setSheetName(sheetName);
            sheetInfo.setSheetNameCell(sheetNameCell);
            sheetInfo.setLogicalNameRowNum(logicalRowNum);
            sheetInfo.setLogicalNameRowNumCell(logicalRowNumCell);
            sheetInfo.setValueRowNum(valueRowNum);
            sheetInfo.setValueRowNumCell(valueRowNumCell);
            sheetInfoList.add(sheetInfo);
        }
        return sheetInfoList;
    }
}

