/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: TransProcessor.java 28 2009-07-02 04:38:39Z yuta-takahashi $
 * $Revision: 28 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.processor;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.core.exporter.sheet.SheetExporter;
import org.bbreak.excella.core.handler.ParseErrorHandler;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.trans.listener.TransProcessListener;

/**
 * f[^ڍsvZbT
 * 
 * @since 1.0
 */
public class TransProcessor {

    /**
     * Rg̃vtBbNX
     */
    public static final String COMMENT_PREFIX = BookController.COMMENT_PREFIX;

    /**
     * /** ubNRg[
     */
    private BookController controller = null;

    /**
     * [NubN
     */
    private Workbook workbook = null;

    /**
     * vZXXĩXg
     */
    private List<TransProcessListener> processListeners = new ArrayList<TransProcessListener>();

    /**
     * RXgN^
     * 
     * @param filePath ΏExcelt@CpX
     * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
     */
    public TransProcessor( String filePath) throws IOException {
        // 
        init( filePath);
    }

    /**
     * 
     * 
     * @param filePath ΏExcelt@CpX
     * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
     */
    private void init( String filePath) throws IOException {

        // [NubN擾
        this.workbook = getWorkbook( filePath);

        // Rg[
        this.controller = new BookController( workbook);

        // ftHg^Op[Tǉ
        for ( TagParser<?> tagParser : TransCreateHelper.getDefaultTagParsers()) {
            addTagParser( tagParser);
        }

        // ftHgV[gXiǉ
        for ( SheetParseListener listener : TransCreateHelper.getDefaultSheetParseListeners()) {
            addSheetParseListener( listener);
        }
    }

    /**
     * w肵pX̃[NubN擾
     * 
     * @param filePath ΏExcelt@CpX
     * @return workbook p[XO
     * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
     */
    private Workbook getWorkbook( String filePath) throws IOException {

        Workbook workbook = null;
        if ( filePath.endsWith( BookController.XSSF_SUFFIX)) {
            // XSSF`
            workbook = new XSSFWorkbook( filePath);
        } else {
            // HSSF`
            FileInputStream stream = new FileInputStream( filePath);
            POIFSFileSystem fs = new POIFSFileSystem( stream);
            workbook = new HSSFWorkbook( fs);
            stream.close();
        }
        return workbook;
    }

    /**
     * ubN͂s
     * 
     * @return bookData ubNf[^
     * @throws ParseException p[XO
     * @throws ExportException o͏O
     */
    public BookData processBook() throws ParseException, ExportException {
        return processBook( null);
    }

    /**
     * ubN͂s
     * 
     * @param data TagParser.parse\bh܂ňp鏈f[^
     * @return bookData ubNf[^
     * @throws ParseException p[XO
     * @throws ExportException o͏O
     */
    public BookData processBook( Object data) throws ParseException, ExportException {

        // ubN͑O
        for ( TransProcessListener listener : processListeners) {
            listener.preBookParse( workbook);
        }

        controller.parseBook( data);

        // ubN͌㏈
        for ( TransProcessListener listener : processListeners) {
            listener.postBookParse( workbook, controller.getBookData());
        }

        return controller.getBookData();
    }

    /**
     * V[g͂s
     * 
     * @param sheetName V[g
     * @return sheetData V[gf[^
     * @throws ParseException p[XO
     * @throws ExportException o͏O
     */
    public SheetData processSheet( String sheetName) throws ParseException, ExportException {

        return processSheet( sheetName, null);

    }

    /**
     * V[g͂s
     * 
     * @param sheetName V[g
     * @param data TagParser.parse\bh܂ňp鏈f[^
     * @return sheetData V[gf[^
     * @throws ParseException p[XO
     * @throws ExportException o͏O
     */
    public SheetData processSheet( String sheetName, Object data) throws ParseException, ExportException {

        SheetData sheetData = null;
        sheetData = controller.parseSheet( sheetName, data);
        return sheetData;
    }

    /**
     * ^OftHgSqlp[T̃^Oǂ𔻕ʂʂԂ
     * 
     * @param tag 肷^O
     * @return ftHgSqlp[T̃^ȌꍇtrueAȊȌꍇfalse
     */
    public Boolean isDefaultSqlTag( String tag) {

        boolean result = false;

        List<String> defaultSqlTags = TransCreateHelper.getDefaultSqlTags();
        if ( defaultSqlTags.contains( tag)) {
            result = true;
        }

        return result;
    }

    /**
     * ubNɊ܂܂V[g̈ꗗ擾(RgV[g܂)
     * 
     * @return V[g̈ꗗ
     */
    public List<String> getSheetNames() {
        return controller.getSheetNames();
    }

    /**
     * ^Op[T̒ǉ
     * 
     * @param tagParser ǉ^Op[T
     */
    public void addTagParser( TagParser<?> tagParser) {
        this.controller.addTagParser( tagParser);
    }

    /**
     * ΏۃV[gwł̃^Op[T̒ǉ
     * 
     * @param sheetName ΏۃV[g
     * @param tagParser ǉ^Op[T
     */
    public void addTagParser( String sheetName, TagParser<?> tagParser) {
        this.controller.addTagParser( sheetName, tagParser);
    }

    /**
     * w^Õ^Op[T폜
     * 
     * @param tag ^O
     */
    public void removeTagParser( String tag) {
        this.controller.removeTagParser( tag);
    }

    /**
     * ׂẴ^Op[T폜
     */
    public void clearTagParsers() {
        this.controller.clearTagParsers();
    }

    /**
     * ubNo͏NX̒ǉ
     * 
     * @param bookExporter ubNo͏NX
     */
    public void addBookExporter( BookExporter bookExporter) {
        this.controller.addBookExporter( bookExporter);
    }

    /**
     * ׂẴubNo͏NX폜
     */
    public void clearBookExporters() {
        this.controller.clearBookExporters();
    }

    /**
     * V[go͏NX̒ǉ
     * 
     * @param sheetExporter V[go͏NX
     */
    public void addSheetExporter( SheetExporter sheetExporter) {
        this.controller.addSheetExporter( sheetExporter);
    }

    /**
     * ΏۃV[gwł̃V[go͏NX
     * 
     * @param sheetName ΏۃV[g
     * @param sheetExporter V[go͏NX
     */
    public void addSheetExporter( String sheetName, SheetExporter sheetExporter) {
        this.controller.addSheetExporter( sheetName, sheetExporter);
    }

    /**
     * ׂẴV[go͏NX폜
     */
    public void clearSheetExporters() {
        this.controller.clearSheetExporters();
    }

    /**
     * G[nh̎擾
     * 
     * @return G[nh
     */
    public ParseErrorHandler getErrorHandler() {
        return this.controller.getErrorHandler();
    }

    /**
     * G[nh̐ݒ
     * 
     * @param errorHandler G[nh
     */
    public void setErrorHandler( ParseErrorHandler errorHandler) {
        this.controller.setErrorHandler( errorHandler);
    }

    /**
     * V[gXiNX̒ǉ
     * 
     * @param sheetParseListener V[gXiNX
     */
    public void addSheetParseListener( SheetParseListener sheetParseListener) {
        this.controller.addSheetParseListener( sheetParseListener);
    }

    /**
     * ΏۃV[gwł̃V[gXiNX̒ǉ
     * 
     * @param sheetName ΏۃV[g
     * @param sheetParseListener V[gXiNX
     */
    public void addSheetParseListener( String sheetName, SheetParseListener sheetParseListener) {
        this.controller.addSheetParseListener( sheetName, sheetParseListener);
    }

    /**
     * ׂẴV[gXiNX폜
     */
    public void clearSheetParseListeners() {
        this.controller.clearSheetParseListeners();
    }

    /**
     * vZXXiNXǉ
     * 
     * @param processListener ǉvZXXiNX
     */
    public void addTransProcessListener( TransProcessListener processListener) {
        this.processListeners.add( processListener);
    }

    /**
     * ׂẴvZXXiNX폜
     */
    public void clearTransProcessListeners() {
        this.processListeners.clear();
    }
}
