/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaPropertyParser.java 59 2009-11-18 04:25:47Z akira-yokoi $
 * $Revision: 59 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.bbreak.excella.core.exception.ParseException;

/**
 * SheetToJavapƎvpeB̓NX
 * 
 * @since 1.0
 */
public abstract class SheetToJavaPropertyParser {

    /**
     * ̃p[Tŏ^O
     */
    private String tag;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SheetToJavaPropertyParser( String tag) {
        this.tag = tag;
    }

    /**
     * ^O擾
     * 
     * @return ̃p[Tŏ^O
     */
    public String getTag() {
        return tag;
    }

    /**
     * ^Oݒ肷
     * 
     * @param tag ̃p[Tŏ^O
     */
    public void setTag( String tag) {
        this.tag = tag;
    }

    /**
     * p[Xsۂ̔
     * 
     * @param tagCell ΏۃZ
     * @return Ώۂ̏ꍇtrueAΏۊȌꍇfalse
     * @throws ParseException p[XO
     */
    public boolean isParse( Cell tagCell) throws ParseException {
        if ( tagCell == null) {
            return false;
        }

        // 񂩂A^O܂ރZ̏ꍇ͏Ώ
        if ( tagCell.getCellType() == Cell.CELL_TYPE_STRING) {
            if ( tagCell.getStringCellValue().contains( tag)) {
                return true;
            }
        }
        return false;
    }

    /**
     * p[Xsۂ̔
     * 
     * @param propertyName vpeB
     * @return Ώۂ̏ꍇtrueAΏۊȌꍇfalse
     */
    public boolean isParse( String propertyName) {

        if ( propertyName == null) {
            return false;
        }

        if ( propertyName.contains( tag)) {
            return true;
        }

        return false;
    }

    /**
     * p[Xs
     * 
     * @param object ΏۃIuWFNg
     * @param paramCellMap p[^ƃZ̃}bv
     * @param paramValue p[^ƒl̃}bv
     * @throws ParseException p[XO
     */
    public abstract void parse( Object object, Map<String, Cell> paramCellMap, Map<String, Object> paramValueMap) throws ParseException;
}
