/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaSettingParser.java 40 2009-11-12 04:51:10Z akira-yokoi $
 * $Revision: 40 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;

/**
 * V[g̖׏͂p[T
 * 
 * @since 1.0
 */
public class SheetToJavaSettingParser extends TagParser<List<SheetToJavaSettingInfo>> {

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "@SheetToJavaSetting";

    /**
     * f[^Jns̒p[^
     */
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";

    /**
     * f[^Is̒p[^
     */
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";

    /**
     * ftHgf[^Jnsl
     */
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;

    /**
     * j[NvpeB̃}[N
     */
    protected static final String UNIQUE_PROPERTY_MARK = "";

    /**
     * RXgN^
     */
    public SheetToJavaSettingParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SheetToJavaSettingParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR> 
     *              nꍇTagParser.parse\bh܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<SheetToJavaSettingInfo> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        // ^ÕCfbNX
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();

        // f[^sCfbNX
        int valueRowFromIdx;
        int valueRowToIdx = sheet.getLastRowNum();

        try {
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // f[^Jns̒
            valueRowFromIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, DEFAULT_DATA_ROW_FROM_ADJUST);
            if ( valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_FROM);
            }

            // f[^Is̒
            valueRowToIdx = TagUtil.adjustValue( tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx);
            if ( valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_TO);
            }
            
            // f[^JnsƏIs̊֌W`FbN
            if ( valueRowFromIdx > valueRowToIdx) {
                throw new ParseException( tagCell, "p[^lsF" + PARAM_DATA_ROW_FROM + "," + PARAM_DATA_ROW_TO);
            }

        } catch ( Exception e) {
            if ( e instanceof ParseException) {
                throw ( ParseException) e;
            } else {
                throw new ParseException( tagCell, e);
            }
        }

        List<SheetToJavaSettingInfo> sheetSettingInfoList = new ArrayList<SheetToJavaSettingInfo>();

        // V[gCfbNX
        int sheetNameColIdx = tagColIdx++;
        // lCfbNX
        int valueColIdx = tagColIdx++;
        // ΏۃGeBeBCfbNX
        int classColIdx = tagColIdx++;
        // ΏۃvpeBCfbNX
        int propertyNameColIdx = tagColIdx++;
        // dtCfbNX
        int uniqueColIdx = tagColIdx++;

        // V[g`FbNpɃ[NubN擾
        Workbook workbook = sheet.getWorkbook();

        // V[g̓ǂݍ
        for ( int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; rowNum++) {
            Row row = sheet.getRow( rowNum);
            if ( row != null) {
                // Z̎擾
                Cell sheetNameCell = row.getCell( sheetNameColIdx);
                Cell valueCell = row.getCell( valueColIdx);
                Cell classCell = row.getCell( classColIdx);
                Cell propertyNameCell = row.getCell( propertyNameColIdx);
                Cell uniqueCell = row.getCell( uniqueColIdx);

                // K{`FbN
                if ( (sheetNameCell == null) && (valueCell == null) && (classCell == null) 
                        && (propertyNameCell == null) && (uniqueCell == null)) {
                    // ΏۃZׂnull̏ꍇ
                    continue;

                } else if ((sheetNameCell == null) 
                        || (sheetNameCell.getStringCellValue() == null)
                        || ("".equals( sheetNameCell.getStringCellValue()))) {
                    // V[gݒ肳ĂȂꍇ
                    continue;

                } else {
                    // ȊȌꍇ
                    Cell requiredErrorCell = null;
                    if ( classCell == null) {
                        // ΏۃNXZnull̏ꍇ
                        requiredErrorCell = row.createCell( classColIdx);
                    }

                    // K{G[͗O𓊂
                    if ( requiredErrorCell != null) {
                        throw new ParseException( requiredErrorCell, "K{Znullł");
                    }
                }

                // ̓V[g̏ڍ׏
                SheetToJavaSettingInfo settingInfo = new SheetToJavaSettingInfo();

                // V[g̑݃`FbN
                String sheetName = sheetNameCell.getStringCellValue();
                if ( workbook.getSheet( sheetName) == null) {
                    throw new ParseException( sheetNameCell, "V[g[" + sheetName + "]݂͑܂");
                }

                // V[gݒ
                settingInfo.setSheetName( sheetName);
                settingInfo.setSheetNameCell(  sheetNameCell);

                // ΏۃGeBeB̃NXݒ
                try {
                    settingInfo.setClazz( Class.forName( classCell.getStringCellValue()));
                    settingInfo.setClazzCell( classCell);
                } catch ( ClassNotFoundException e) {
                    throw new ParseException( classCell, e);
                }

                // l
                Object value = PoiUtil.getCellValue( valueCell);
                settingInfo.setValueCell( valueCell);

                // l^Oǂ
                boolean isValueTag = false;
                // l_^Oǂ
                boolean isValueLogicalNameTag = false;
                if ( value instanceof String) {
                    // ̏ꍇ
                    String valueStr = ( String) value;
                    if ( (valueStr).startsWith( SheetToJavaExecuter.TAG_PREFIX)) {
                        // ^Ȍꍇ
                        isValueTag = true;
                        if ( (valueStr).startsWith( SheetToJavaExecuter.TAG_LOGICAL_NAME_PREFIX)) {
                            // _^Ȍꍇ
                            isValueLogicalNameTag = true;
                        }
                    }
                }

                if ( !isValueTag || isValueLogicalNameTag) {
                    // l^OȊO܂͘_^Ȍꍇ

                    // ΏۃvpeBZ̕K{`FbN
                    Cell requiredErrorCell = null;
                    if ( propertyNameCell == null) {
                        requiredErrorCell = row.createCell( propertyNameColIdx);
                    }
                    if ( requiredErrorCell != null) {
                        throw new ParseException( requiredErrorCell, "K{Znullł");
                    }

                    // ΏۃvpeB̐ݒ
                    settingInfo.setPropertyName( propertyNameCell.getStringCellValue());
                    settingInfo.setPropertyNameCell(  propertyNameCell);

                    // vpeB݃`FbN
                    Class<?> propertyClass = null;
                    try {
                        Object obj = settingInfo.getClazz().newInstance();
                        propertyClass = PropertyUtils.getPropertyType( obj, settingInfo.getPropertyName());
                    } catch ( Exception e) {
                        throw new ParseException( propertyNameCell, e);
                    }
                    if ( propertyClass == null) {
                        throw new ParseException( propertyNameCell, "vpeBs:" + settingInfo.getPropertyName());
                    }

                    // ds̐ݒ
                    if ( uniqueCell != null) {
                        if ( uniqueCell.getStringCellValue() != null && uniqueCell.getStringCellValue().equals( UNIQUE_PROPERTY_MARK)) {
                            settingInfo.setUnique( true);
                            settingInfo.setUniqueCell( uniqueCell);
                        }
                    }
                } else {
                    // JX^vpeB^Ȍꍇ

                    // p[^``FbN
                    try {
                        TagUtil.getParams( ( String) value);
                    } catch ( Exception e) {
                        throw new ParseException( valueCell, e);
                    }
                }

                // ^ϊ邩ǂ
                boolean checkTypeFlag = false;
                if ( value instanceof String) {
                    if ( !isValueTag) {
                        // ^OȊȌꍇ
                        checkTypeFlag = true;
                    }
                } else {
                    // ȊȌꍇ
                    if ( value != null) {
                        // nullȊȌꍇ
                        checkTypeFlag = true;
                    }
                }

                // l̐ݒ
                if ( checkTypeFlag) {
                    // lZbgۂɌ^ϊ
                    Object obj;
                    try {
                        obj = settingInfo.getClazz().newInstance();
                        Class<?> propertyClass = PropertyUtils.getPropertyType( obj, settingInfo.getPropertyName());
                        value = PoiUtil.getCellValue( valueCell, propertyClass);
                    } catch ( Exception e) {
                        throw new ParseException( valueCell, e);
                    }
                }
                settingInfo.setValue( value);

                // ʃXgɊi[
                sheetSettingInfoList.add( settingInfo);
            }
        }
        return sheetSettingInfoList;
    }
}
