/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToSqlExecuter.java 72 2011-05-31 10:40:32Z akira-yokoi $
 * $Revision: 72 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2sql.converter.SheetToSqlDataConverter;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlInfo;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlParseInfo;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlSettingInfo;

/**
 * V[g͂AInsert<BR>
 * SQLList&lt;String&gt;Ŏ擾
 * 
 * @since 1.0
 */
public class SheetToSqlExecuter implements SheetParseListener {

    /**
     * _p[^`̊Jn
     */
    protected static final String LNAME_TAG_PARAM_PREFIX = "(";

    /**
     * _p[^`̏I
     */
    protected static final String LNAME_TAG_PARAM_SUFFIX = ")";

    /**
     * _^O
     */
    protected static final String TAG_LOGICAL_NAME_PREFIX = "@LNAME(";

    /**
     * f[^Ro[^
     */
    private SheetToSqlDataConverter dataConverter = null;

    /**
     * ͑O
     * 
     * @param sheet ΏۃV[g
     * @param sheetParser ΏۃV[gp[T
     */
    public void preParse( Sheet sheet, SheetParser sheetParser) {
        // do nothing
    }

    /**
     * ͌㏈<BR>
     * ݒɊÂAf[^SqlɕϊA<BR>
     * ʂXgɓāASheetDataɃZbgB<BR>
     * 
     * @param sheet ΏۃV[g
     * @param sheetParser ΏۃV[gp[T
     * @param sheetData ͌ʃV[gf[^
     */
    @SuppressWarnings( "unchecked")
    public void postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {

        // ʃIuWFNg̃Xg
        List<Object> results = new ArrayList<Object>();

        // ΏۃV[gSheetToSqlParser݂邩
        List<TagParser<?>> tagParsers = sheetParser.getTagParsers();

        // svɂȂSheetToJavaSettingParser
        // f[^𔻕ʂ^ÕXg
        List<String> removeTags = new ArrayList<String>();

        // ^Öꗗ쐬
        List<String> targetTags = new ArrayList<String>();
        for ( TagParser<?> tagParser : tagParsers) {
            // SheetToSqlParser̃^O
            if ( tagParser instanceof SheetToSqlParser) {
                targetTags.add( tagParser.getTag());
            }
            // SheetToSqlSettingParser̃^O
            if ( tagParser instanceof SheetToSqlSettingParser) {
                removeTags.add( tagParser.getTag());
            }
        }

        // [NubN̎擾
        Workbook workbook = sheet.getWorkbook();

        // Ώۂ̃^OŃ[v
        for ( String tag : targetTags) {

            List<SheetToSqlParseInfo> sheetInfoList = ( List<SheetToSqlParseInfo>) sheetData.get( tag);

            if ( sheetInfoList == null) {
                continue;
            }

            // ݒ(V[g)PʂŃ[v
            for ( SheetToSqlParseInfo sheetInfo : sheetInfoList) {

                List<SheetToSqlSettingInfo> allColumnInfoList = ( List<SheetToSqlSettingInfo>) sheetData.get( sheetInfo.getSettingTagName());

                // 񏈗ΏۃV[g̐ݒ擾
                List<SheetToSqlSettingInfo> targetColumnInfoList = new ArrayList<SheetToSqlSettingInfo>();
                for ( SheetToSqlSettingInfo columnInfo : allColumnInfoList) {
                    if ( columnInfo.getSheetName().equals( sheetInfo.getSheetName())) {
                        targetColumnInfoList.add( columnInfo);
                    }
                }

                // ΏۃV[gf[^̓ǂݍ
                Sheet targetSheet = workbook.getSheet( sheetInfo.getSheetName());
                if ( targetSheet == null) {
                    throw new ParseException( "V[g[" + sheetInfo.getSheetName() + "]݂͑܂");
                }
                results.addAll( parseTargetSheet( targetSheet, sheetInfo, targetColumnInfoList));
            }

            // sheetDataɌʂi[
            sheetData.put( tag, results);
        }

        // ɕsvɂȂf[^̍폜
        for ( String removeTag : removeTags) {
            sheetData.remove( removeTag);
        }
    }

    /**
     * ݒɊÂAΏۃV[gInsertSql<BR>
     * ϊAXgɓĕԋp<BR>
     * 
     * @param targetSheet ͑ΏۃV[g
     * @param targetColumnInfoList ݒ
     * @return SqlXg
     * @throws ParseException p[XO
     */
    protected List<Object> parseTargetSheet( Sheet targetSheet, SheetToSqlParseInfo sheetInfo, List<SheetToSqlSettingInfo> targetColumnInfoList) throws ParseException {

        // ʃIuWFNg̃Xg
        List<Object> results = new ArrayList<Object>();

        int logicalRowNum = sheetInfo.getLogicalNameRowNum() - 1;
        int valueStartRowNum = sheetInfo.getValueRowNum() - 1;
        int valueEndRowNum = targetSheet.getLastRowNum();

        // _AΉJindex̃}bv
        Map<String, Integer> colLogicalNameMap = new HashMap<String, Integer>();

        // colLogicalNameMap쐬
        Row row = targetSheet.getRow( logicalRowNum);
        if ( row != null) {

            // _s̊JnƏI
            int firstColIdx = row.getFirstCellNum();
            int lastColIdx = row.getLastCellNum();

            for ( int colIdx = firstColIdx; colIdx <= lastColIdx; colIdx++) {
                Cell cell = row.getCell( colIdx);
                if ( cell != null) {
                    try {
                        // _
                        String logicalCellValue = cell.getStringCellValue();
                        if ( !logicalCellValue.startsWith( BookController.COMMENT_PREFIX)) {
                            colLogicalNameMap.put( logicalCellValue, colIdx);
                        }
                    } catch ( Exception e) {
                        throw new ParseException( cell, e);
                    }
                }
            }
        }

        // `ɏKv邽߁Af[^̏Ԃێ郊Xg
        List<String> tableNameList = new ArrayList<String>();

        // NXASettingInfoXg̃}bv
        Map<String, List<SheetToSqlSettingInfo>> settingInfoListMap = new HashMap<String, List<SheetToSqlSettingInfo>>();
        // NXAdsvpeBXg̃}bv
        Map<String, List<String>> uniqueColumnListMap = new HashMap<String, List<String>>();
        for ( SheetToSqlSettingInfo settingInfo : targetColumnInfoList) {

            // }bv烊Xg擾
            String tableName = settingInfo.getTableName();
            List<SheetToSqlSettingInfo> settingInfoList = settingInfoListMap.get( tableName);
            if ( settingInfoList == null) {
                // 擾łȂꍇ
                settingInfoList = new ArrayList<SheetToSqlSettingInfo>();
            }
            List<String> uniqueColumnList = uniqueColumnListMap.get( tableName);
            if ( uniqueColumnList == null) {
                // 擾łȂꍇ
                uniqueColumnList = new ArrayList<String>();
            }

            // Xgɒǉ
            settingInfoList.add( settingInfo);
            if ( settingInfo.isUnique()) {
                uniqueColumnList.add( settingInfo.getColumnName());
            }

            // f[^̏Ԃێ
            if ( !tableNameList.contains( tableName)) {
                tableNameList.add( tableName);
            }

            // }bvɋl߂
            settingInfoListMap.put( tableName, settingInfoList);
            uniqueColumnListMap.put( tableName, uniqueColumnList);
        }

        // e[uƂ̃[v
        for ( String tableName : tableNameList) {

            // SQL쐬ɕKvȏێNX̃Xg
            List<SheetToSqlInfo> infoList = new ArrayList<SheetToSqlInfo>();

            SheetToSqlInfo info = null;

            // f[^sƂ̃[v
            for ( int valueRowIdx = valueStartRowNum; valueRowIdx <= valueEndRowNum; valueRowIdx++) {

                Map<String, String> columnValueMap = new HashMap<String, String>();
                List<String> columnNameList = new ArrayList<String>();

                // SheetToSqlInfoCX^X
                info = new SheetToSqlInfo();
                info.setTableName( tableName);
                info.setColumnValueMap( columnValueMap);
                info.setColumnNameList( columnNameList);

                Row valueRow = targetSheet.getRow( valueRowIdx);
                if ( valueRow == null) {
                    continue;
                }

                // JƂ̃[v
                List<SheetToSqlSettingInfo> settingInfoList = settingInfoListMap.get( tableName);
                for ( SheetToSqlSettingInfo settingInfo : settingInfoList) {
                    // J
                    String columnName = settingInfo.getColumnName();
                    // l
                    Object value = settingInfo.getValue();
                    // f[^^
                    String dataType = settingInfo.getDataType();

                    // Ro[gΏۂvalue
                    Object target = value;
                    Cell cell = null;

                    if ( value instanceof String) {
                        // l̏ꍇ
                        String settingValueStr = ( String) value;
                        if ( settingValueStr.startsWith( TAG_LOGICAL_NAME_PREFIX)) {
                            // _^Ȍꍇ
                            String logicalKey = TagUtil.getParam( settingValueStr, LNAME_TAG_PARAM_PREFIX, LNAME_TAG_PARAM_SUFFIX);
                            Integer logicalKeyCol = colLogicalNameMap.get( logicalKey);
                            if ( logicalKeyCol == null) {
                                throw new ParseException( settingInfo.getValueCell(), "_^Op[^s:" + logicalKey);
                            }

                            // Ro[gΏۂ͘_Œ`ꂽZ̒l
                            cell = valueRow.getCell( logicalKeyCol);
                            target = PoiUtil.getCellValue( cell);
                        }
                    }

                    // ΏۂRo[g
                    try{
                    	String valueStr = dataConverter.convert( target, dataType, settingInfo);

                        // }bvɒli[
                        columnValueMap.put( columnName, valueStr);

                        // XgɃJi[
                        columnNameList.add( columnName);
                    }
                    catch (ParseException parseEx){
                    	// lɕϊꍇl̃ZĂꍇ̓Z㏑
                    	if( cell != null){
                        	parseEx.setCell(cell);
                    	}
                    	throw parseEx;
                    }
                }

                List<String> uniqueColumnList = uniqueColumnListMap.get( tableName);
                if ( !isDuplicateObj( info, infoList, uniqueColumnList)) {
                    // dĂȂꍇ
                    infoList.add( info);
                }
            }

            // SQL̃Xg쐬AʃXgɊi[
            List<String> sqlList = createInsertSqlList( infoList);
            results.addAll( sqlList);
        }

        return results;
    }

    /**
     * SheetToSqlInfõXgInsert̃Xg쐬
     * 
     * @param infoList SQL쐬ɕKvȏ̃Xg
     * @return Insert̃Xg
     */
    private List<String> createInsertSqlList( List<SheetToSqlInfo> infoList) {

        // SQL̃Xg
        List<String> sqlList = new ArrayList<String>();

        for ( SheetToSqlInfo info : infoList) {

            StringBuilder strBuild = new StringBuilder();
            strBuild.append( "insert into ");
            strBuild.append( info.getTableName());
            strBuild.append( " (");

            Map<String, String> columnValueMap = info.getColumnValueMap();
            List<String> columnNameList = info.getColumnNameList();

            for ( int index = 0; index < columnNameList.size(); index++) {

                String columnName = columnNameList.get( index);

                // J
                strBuild.append( columnName);

                if ( index < columnNameList.size() - 1) {
                    // J}t^
                    strBuild.append( ",");
                }
            }

            strBuild.append( ") ");
            strBuild.append( "values");
            strBuild.append( " (");

            for ( int index = 0; index < columnNameList.size(); index++) {

                String columnName = columnNameList.get( index);
                String value = columnValueMap.get( columnName);

                // l
                if ( value == null) {
                    // null̏ꍇ
                    strBuild.append( "null");
                } else {
                    strBuild.append( value);
                }

                if ( index < columnNameList.size() - 1) {
                    // J}t^
                    strBuild.append( ",");
                }
            }

            strBuild.append( ");");

            sqlList.add( strBuild.toString());
        }

        return sqlList;
    }

    /**
     * dIuWFNg݂邩𔻒肷B<BR>
     * Xg̒ɑΏۃIuWFNgƃj[NvpeB̒l<BR>
     * SĈvIuWFNg݂ꍇtrueԂB<BR>
     * 
     * @param targetInfo ΏۃIuWFNg
     * @param infoList SheetToSqlInfõXg
     * @param uniqueColumnList j[NJ̃Xg
     * @return result dIuWFNg݂ꍇtrueA݂Ȃꍇfalse
     */
    private boolean isDuplicateObj( SheetToSqlInfo targetInfo, List<SheetToSqlInfo> infoList, List<String> uniqueColumnList) {

        boolean result = false;

        if ( infoList.size() == 0) {
            // SheetToSqlInfõXg̏ꍇ
            return false;
        }

        if ( uniqueColumnList.size() == 0) {
            // j[NJ̃Xg̏ꍇ
            return false;
        }

        for ( SheetToSqlInfo info : infoList) {
            // j[NvpeBldĂ邩ǂ
            boolean isDuplicate = true;
            Map<String, String> targetValueMap = targetInfo.getColumnValueMap();
            Map<String, String> columnValueMap = info.getColumnValueMap();

            for ( String columnName : uniqueColumnList) {

                String targetValue = targetValueMap.get( columnName);
                String infoValue = columnValueMap.get( columnName);

                if ( targetValue == null) {
                    if ( infoValue != null) {
                        isDuplicate = false;
                    }
                } else if ( !targetValue.equals( infoValue)) {
                    isDuplicate = false;
                }
            }
            if ( isDuplicate) {
                // dĂꍇ
                result = true;
                break;
            }
        }
        return result;
    }

    /**
     * f[^Ro[^擾
     * 
     * @return f[^Ro[^
     */
    public SheetToSqlDataConverter getDataConverter() {
        return dataConverter;
    }

    /**
     * f[^Ro[^ݒ肷
     * 
     * @param dataConverter f[^Ro[^
     */
    public void setDataConverter( SheetToSqlDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }
}
