/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo;

import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.ConstantValueCellSeeker;
import net.w_horse.excelpojo.excel.HorizontalRepeatsSeeker;
import net.w_horse.excelpojo.excel.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.MappedCellSeeker;
import net.w_horse.excelpojo.excel.PointedCellSeeker;
import net.w_horse.excelpojo.excel.SheetNotFoundException;
import net.w_horse.excelpojo.excel.VerticalRepeatsSeeker;
import net.w_horse.excelpojo.xml.tag.RetrieveType;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ExcelPOJOBridge {
    private String sheetName;
    private String targetClass = "";
    private HashMap<String, AbstractCellSeeker> targetClassProperties = new HashMap();
    private AbstractCellSeeker cellSeeker;

    public ExcelPOJOBridge() {
    }

    public ExcelPOJOBridge(Class<?> clazz) throws ExcelPOJOException {
        Bean bean = clazz.getAnnotation(Bean.class);
        if (bean == null) {
            throw new ExcelPOJOException("There is no annotation specified on the target class.");
        }
        try {
            this.setSheetName(bean.sheetName());
            if (bean.retrieveType() == RetrieveType.NONE) {
                this.setTargetClass(clazz.getCanonicalName());
            } else {
                ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
                AbstractCellSeeker abstractCellSeeker = this.buildCellSeeker(bean.retrieveType());
                excelPOJOAnnotationParser.setTargetClass(clazz.getCanonicalName());
                abstractCellSeeker.set(bean, excelPOJOAnnotationParser);
                this.setCellSeeker(abstractCellSeeker);
            }
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
    }

    public Object load(String string) throws ExcelPOJOException {
        if (this.getSheetName() == null) {
            throw new ExcelPOJOException("There is no sheet name specified.");
        }
        return this.load(string, this.getSheetName());
    }

    public Object load(String string, String string2) throws ExcelPOJOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            Object object = this.load(fileInputStream, string2);
            return object;
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object load(InputStream inputStream) throws ExcelPOJOException {
        return this.load(inputStream, this.getSheetName());
    }

    public Object load(InputStream inputStream, String string) throws ExcelPOJOException {
        Object object;
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(new POIFSFileSystem(inputStream));
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheet(string);
            if (hSSFSheet == null) {
                throw new SheetNotFoundException(string);
            }
            if (this.getCellSeeker() != null) {
                return this.getCellSeeker().seekCellValue(hSSFSheet, null);
            }
            Class clazz = ClassUtils.forName((String)this.getTargetClass());
            ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
            excelPOJOAnnotationParser.setTargetClassProperties(this.getTargetClassProperties(), clazz);
            object = Utils.instantiateTarget(this.getTargetClass());
            for (String string2 : this.getTargetClassProperties().keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz, (String)string2);
                AbstractCellSeeker abstractCellSeeker = this.getTargetClassProperties().get(string2);
                Object object2 = abstractCellSeeker.seekCellValue(hSSFSheet, propertyDescriptor.getPropertyType());
                ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{object2});
            }
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        return object;
    }

    public void save(String string, Object object) throws ExcelPOJOException {
        this.save(string, this.getSheetName(), string, object);
    }

    public void save(String string, String string2, Object object) throws ExcelPOJOException {
        this.save(string, string2, string, object);
    }

    public void save(String string, String string2, String string3, Object object) throws ExcelPOJOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(new POIFSFileSystem((InputStream)fileInputStream));
            this.save(hSSFWorkbook, string2, string3, object);
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void save(HSSFWorkbook hSSFWorkbook, String string, String string2, Object object) throws ExcelPOJOException {
        FileOutputStream fileOutputStream = null;
        try {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheet(string);
            if (hSSFSheet == null) {
                throw new SheetNotFoundException(string);
            }
            if (this.getCellSeeker() != null) {
                this.getCellSeeker().setValue(hSSFSheet, object);
            }
            for (String string3 : this.getTargetClassProperties().keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)string3);
                if (propertyDescriptor == null) continue;
                AbstractCellSeeker abstractCellSeeker = this.getTargetClassProperties().get(string3);
                Object object2 = ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), (Object)object, (Object[])new Object[0]);
                abstractCellSeeker.setValue(hSSFSheet, object2);
            }
            fileOutputStream = new FileOutputStream(string2);
            hSSFWorkbook.write((OutputStream)fileOutputStream);
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setTargetClass(String string) {
        this.targetClass = string;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClassProperties(HashMap<String, AbstractCellSeeker> hashMap) {
        this.targetClassProperties = hashMap;
    }

    public HashMap<String, AbstractCellSeeker> getTargetClassProperties() {
        return this.targetClassProperties;
    }

    public void setCellSeeker(AbstractCellSeeker abstractCellSeeker) {
        this.cellSeeker = abstractCellSeeker;
    }

    public AbstractCellSeeker getCellSeeker() {
        return this.cellSeeker;
    }

    private AbstractCellSeeker buildCellSeeker(RetrieveType retrieveType) {
        AbstractCellSeeker abstractCellSeeker = null;
        switch (retrieveType) {
            case LABELED_CELL: {
                abstractCellSeeker = new LabeledCellSeeker();
                break;
            }
            case POINTED_CELL: {
                abstractCellSeeker = new PointedCellSeeker();
                break;
            }
            case CONSTANT_VALUE: {
                abstractCellSeeker = new ConstantValueCellSeeker();
                break;
            }
            case VERTICAL_REPEATS: {
                abstractCellSeeker = new VerticalRepeatsSeeker();
                break;
            }
            case HORIZONTAL_REPEATS: {
                abstractCellSeeker = new HorizontalRepeatsSeeker();
                break;
            }
            case MAPPED_CELL: {
                abstractCellSeeker = new MappedCellSeeker();
            }
        }
        return abstractCellSeeker;
    }
}

