/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.ConstantValueCellSeeker;
import net.w_horse.excelpojo.excel.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.MappedCellSeeker;
import net.w_horse.excelpojo.excel.PointedCellSeeker;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractRepeatsSeeker
extends AbstractCellSeeker {
    private String label;
    private String position;
    private String terminate;
    private String retrieveFrom;
    private String listClass = "java.util.ArrayList";
    private boolean margedRows = false;

    abstract int getRowLimit(HSSFSheet var1);

    abstract AbstractCellSeeker.Offset getOffset(int var1);

    abstract AbstractCellSeeker.Offset getOffset4MappedCell(int var1);

    @Override
    public boolean verify() throws IllegalArgumentException {
        if ((this.getLabel() == null || this.getLabel().isEmpty()) && (this.getPosition() == null || this.getPosition().isEmpty())) {
            throw new IllegalArgumentException("Neither the label nor the position are specified.");
        }
        return true;
    }

    @Override
    public Object seekCellValue(HSSFSheet hSSFSheet, Class<?> clazz) throws ClassNotFoundException, LinkageError, CellNotFoundException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AbstractCellSeeker.Offset offset = this.seekCellPosition(hSSFSheet);
        if (offset == null) {
            if (Use.equalsIgnoreCase(Use.REQUIRED, this.getUse())) {
                throw new CellNotFoundException("label='" + this.getLabel() + "'");
            }
            return this.convertListObject(arrayList, ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass()));
        }
        HashMap<String, AbstractCellSeeker> hashMap = this.getExcelPOJOBridge().getTargetClassProperties();
        int n = this.getRowLimit(hSSFSheet);
        for (int i = 0; i <= n; ++i) {
            Class clazz2 = ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass());
            ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
            excelPOJOAnnotationParser.setTargetClassProperties(hashMap, clazz2);
            Object object = Utils.instantiateTarget(this.getExcelPOJOBridge().getTargetClass());
            boolean bl = false;
            for (String string : hashMap.keySet()) {
                Object object2;
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz2, (String)string);
                if (propertyDescriptor == null) continue;
                AbstractCellSeeker abstractCellSeeker = hashMap.get(string);
                if (abstractCellSeeker instanceof MappedCellSeeker) {
                    object2 = ((MappedCellSeeker)abstractCellSeeker).seekCellValue(hSSFSheet, offset, this.getOffset4MappedCell(0), this.getOffset(i));
                } else if (abstractCellSeeker instanceof ConstantValueCellSeeker) {
                    object2 = ((ConstantValueCellSeeker)abstractCellSeeker).getValue();
                } else {
                    LabeledCellSeeker labeledCellSeeker = (LabeledCellSeeker)abstractCellSeeker;
                    AbstractCellSeeker.Offset offset2 = labeledCellSeeker.seekCellPosition(hSSFSheet, offset, this.getOffset(i));
                    String string2 = this.getCellValue(hSSFSheet, offset2, String.class);
                    if (!this.getTerminate().isEmpty() && string2 != null && string2.equals(this.getTerminate())) break;
                    if (!this.isEmpty(string2)) {
                        bl = true;
                    }
                    object2 = this.getCellValue(hSSFSheet, offset2, propertyDescriptor.getPropertyType());
                    if (this.isEmpty(string2) && (this.isMargedRows() || labeledCellSeeker.isMargedRows())) {
                        object2 = this.seekMargedRowsValue(hSSFSheet, offset2, i, propertyDescriptor.getPropertyType());
                    }
                }
                ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{object2});
            }
            if (!bl) break;
            arrayList.add(object);
        }
        return this.convertListObject(arrayList, ClassUtils.forName((String)this.getExcelPOJOBridge().getTargetClass()));
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet) throws CellNotFoundException {
        return this.seekCellPosition(hSSFSheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) throws CellNotFoundException {
        AbstractCellSeeker abstractCellSeeker;
        if (!this.getLabel().isEmpty()) {
            LabeledCellSeeker labeledCellSeeker = new LabeledCellSeeker();
            labeledCellSeeker.setLabel(this.getLabel());
            labeledCellSeeker.setRetrieveFrom(this.getRetrieveFrom());
            labeledCellSeeker.setUse(this.getUse());
            abstractCellSeeker = labeledCellSeeker;
        } else {
            PointedCellSeeker pointedCellSeeker = new PointedCellSeeker();
            pointedCellSeeker.setPosition(this.getPosition());
            abstractCellSeeker = pointedCellSeeker;
            pointedCellSeeker.setUse(this.getUse());
        }
        return ((AbstractCellSeeker)abstractCellSeeker).seekCellPosition(hSSFSheet, offset, offset2);
    }

    private Object convertListObject(ArrayList<?> arrayList, Class<?> clazz) throws ClassNotFoundException, LinkageError {
        if (this.getListClass().isEmpty()) {
            return arrayList;
        }
        Class clazz2 = ClassUtils.forName((String)this.getListClass());
        if (ClassUtils.isAssignable(List.class, (Class)clazz2)) {
            Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)clazz2, (Class[])new Class[]{Collection.class});
            return BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{arrayList});
        }
        if (clazz2.isArray()) {
            Object object = Array.newInstance(clazz, arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                Array.set(object, i, arrayList.get(i));
            }
            return object;
        }
        return arrayList;
    }

    @Override
    public void setValue(HSSFSheet hSSFSheet, Object object) throws CellNotFoundException {
        AbstractCellSeeker.Offset offset = this.seekCellPosition(hSSFSheet);
        List list = null;
        if (ClassUtils.isAssignable(List.class, object.getClass())) {
            list = (List)object;
        } else if (object.getClass().isArray()) {
            list = CollectionUtils.arrayToList((Object)object);
        }
        HashMap<String, AbstractCellSeeker> hashMap = this.getExcelPOJOBridge().getTargetClassProperties();
        int n = 0;
        for (Object e : list) {
            for (String string : hashMap.keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(e.getClass(), (String)string);
                AbstractCellSeeker abstractCellSeeker = hashMap.get(string);
                Object object2 = ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), e, (Object[])new Object[0]);
                if (abstractCellSeeker instanceof MappedCellSeeker) {
                    ((MappedCellSeeker)abstractCellSeeker).setValue(hSSFSheet, offset, this.getOffset4MappedCell(0), this.getOffset(n), object2);
                    continue;
                }
                abstractCellSeeker.setValue(hSSFSheet, offset, this.getOffset(n), object2);
            }
            ++n;
        }
    }

    @Override
    protected void setValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) {
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public String getPosition() {
        return this.position;
    }

    public void setTerminate(String string) {
        this.terminate = string;
    }

    public String getTerminate() {
        return this.terminate;
    }

    public void setRetrieveFrom(String string) {
        this.retrieveFrom = string;
    }

    public String getRetrieveFrom() {
        return this.retrieveFrom;
    }

    public void setListClass(String string) {
        this.listClass = string;
    }

    public String getListClass() {
        return this.listClass;
    }

    private Object seekMargedRowsValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, int n, Class<?> clazz) {
        Object object = Utils.convertIfNecessary(null, clazz);
        for (int i = 1; i <= n; ++i) {
            AbstractCellSeeker.Offset offset2 = this.getOffset(-i);
            object = this.getCellValue(this.getCell(hSSFSheet, offset, offset2), clazz);
            if (this.isEmpty(object)) continue;
            return object;
        }
        return object;
    }

    private boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        return false;
    }

    public void setMargedRows(boolean bl) {
        this.margedRows = bl;
    }

    public boolean isMargedRows() {
        return this.margedRows;
    }
}

