/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.w3c.dom.Element;

public class LabeledCellSeeker
extends AbstractCellSeeker {
    private String label;
    private String retrieveFrom;
    private String margedLabel;
    private boolean margedRows = false;

    @Override
    public void set(Element element, ExcelPOJOXmlParser excelPOJOXmlParser) {
        excelPOJOXmlParser.setCellSeeker(element, this);
    }

    @Override
    public void set(Annotation annotation, ExcelPOJOAnnotationParser excelPOJOAnnotationParser) {
        excelPOJOAnnotationParser.setCellSeeker(annotation, this);
    }

    @Override
    public boolean verify() throws IllegalArgumentException, ExcelPOJOException {
        super.verify();
        if (this.getLabel() == null || this.getLabel().isEmpty()) {
            throw new IllegalArgumentException("The label is not specified.");
        }
        return true;
    }

    @Override
    public Object seekCellValue(Sheet sheet, Class<?> clazz) throws CellNotFoundException {
        return this.getCellValue(sheet, this.seekCellPosition(sheet), clazz);
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet) throws CellNotFoundException {
        return this.seekCellPosition(sheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) throws CellNotFoundException {
        AbstractCellSeeker.Offset offset3 = this.parseOffset(offset2);
        int n = this.getLimitRowIndex(sheet.getLastRowNum());
        for (int i = this.getStartRowIndex(sheet.getFirstRowNum(), offset.rowIndex); i <= n; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int n2 = this.getLimitColumnIndex(row.getLastCellNum());
            for (int j = this.getStartColIndex(row.getFirstCellNum() - 1, offset.colIndex); j <= n2; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null || !this.getCellValue(cell, String.class).equals(this.getLabel())) continue;
                return new AbstractCellSeeker.Offset(cell.getRowIndex() + offset3.rowIndex, cell.getColumnIndex() + offset3.colIndex);
            }
        }
        if (Use.equalsIgnoreCase(Use.REQUIRED, this.getUse())) {
            throw new CellNotFoundException("label='" + this.getLabel() + "'");
        }
        return null;
    }

    @Override
    public void setValue(Sheet sheet, Object object) throws CellNotFoundException {
        this.setCellValue(this.getCell(sheet, this.seekCellPosition(sheet)), object);
    }

    @Override
    protected void setValue(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) throws CellNotFoundException {
        this.setCellValue(this.getCell(sheet, this.seekCellPosition(sheet, offset, offset2)), object);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRetrieveFrom(String string) {
        this.retrieveFrom = string;
    }

    public String getRetrieveFrom() {
        return this.retrieveFrom;
    }

    public void setMargedLabel(String string) {
        this.margedLabel = string;
    }

    public String getMargedLabel() {
        return this.margedLabel;
    }

    public boolean isMargedRows() {
        return this.margedRows;
    }

    public void setMargedRows(boolean bl) {
        this.margedRows = bl;
    }

    private AbstractCellSeeker.Offset parseOffset(AbstractCellSeeker.Offset offset) {
        String string = this.getRetrieveFrom();
        int n = 0;
        if (this.getMargedLabel() != null && !this.getMargedLabel().isEmpty()) {
            n = Integer.parseInt(this.getMargedLabel());
        }
        AbstractCellSeeker.Offset offset2 = RetrieveFrom.equalsIgnoreCase(RetrieveFrom.LEFT, string) ? new AbstractCellSeeker.Offset(n, -1) : (RetrieveFrom.equalsIgnoreCase(RetrieveFrom.RIGHT, string) ? new AbstractCellSeeker.Offset(n, 1) : new AbstractCellSeeker.Offset(1, n));
        offset2.rowIndex += offset.rowIndex;
        offset2.colIndex += offset.colIndex;
        return offset2;
    }
}

