/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;

public final class WriteableUserPath {
    private final AccessControlContext controlContext = AccessController.getContext();
    private final Path original;
    private final Path real;
    private final String text;
    private volatile boolean inPrivileged;

    public WriteableUserPath(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            throw new FileNotFoundException("Could not write to file: " + path.toAbsolutePath());
        }
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
        bufferedWriter.close();
        this.original = path;
        this.real = path.toRealPath(new LinkOption[0]);
        this.text = this.real.toString();
    }

    public Path getPotentiallyMaliciousOriginal() {
        return this.original;
    }

    public String getText() {
        return this.text;
    }

    public Path getReal() {
        if (!this.inPrivileged) {
            throw new InternalError("A user path was accessed outside the context it was supplied in");
        }
        return this.real;
    }

    public void doPriviligedIO(final Callable<?> callable) throws IOException {
        try {
            this.inPrivileged = true;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    callable.call();
                    return null;
                }
            }, this.controlContext);
        }
        catch (Throwable throwable) {
            throw new IOException("Unexpected error during I/O operation");
        }
        finally {
            this.inPrivileged = false;
        }
    }
}

