<?php
/**
@brief XML ɡϤ뤿δʰ class
@version $Id: XMLLoader.php,v 1.1 2004/07/21 11:20:43 minahito Exp $
*/

/**
@brief XML ɡϤ뤿
δʰŪ class
*/
class AbstractXMLLoader {
	var $parser_;
	var $msg_;
	var $processor_;

	function AbstractXMLLoader($file=null,$charset='iso-8859-1') {
		$this->msg_=array();
		if($processor!==null) {
			$this->processor_=$processor;
		}
		if($file!==null)
			$this->load($charset);
	}

	/**
	@brief 
	*/
	function load($file,$charset='iso-8859-1') {
		if(!file_exists($file)) return false;
		$this->parser_ = xml_parser_create($charset);

		xml_set_object($this->parser_,$this);
		xml_parser_set_option($this->parser_,XML_OPTION_CASE_FOLDING,0);
		xml_set_element_handler($this->parser_,"startElement","endElement");

		$fp=fopen($file,"r");
		if(!$fp) return false;

		while($data=fread($fp,4096)) {
			if(!xml_parse($this->parser_,$data,feof($fp))) {
				$err_string = xml_error_string(xml_get_error_code($this->parser_));
				$line = xml_get_current_line_number($this->parser_);
			}
		}
		
		xml_parser_free($this->parser_);
		
		fclose($fp);
		$this->freeze();

        return true;
	}

	function startElement($parser,$name,$attrs) {
		$method=strtolower($name)."OepnTagHandler";
		$method=str_replace("-","_",$method);
		if(method_exists($this,$method))
			$this->$method($attrs);
	}

	function endElement($parser,$name) {
		$method=strtolower($name)."CloseTagHandler";
		$method=str_replace("-","_",$method);
		if(method_exists($this,$method))
			$this->$method($attrs);
	}
}

?>
