<?php
/**
@brief ŪʥեƤե
*/
/*
 Copyright (c) 2003-2004, minahito
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the nor the names of its contributors may be used to 
  endorse or promote products derived from this software without specific 
  prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 SUCH DAMAGE.
*/

	define ( "ACTIONFORM_INIT_FAIL", 0 );
	define ( "ACTIONFORM_INIT_SUCCESS", 1 );
	define ( "ACTIONFORM_PERFORM_SUCCESS", 2 );

/**
@brief Ūʥ饹
*/
class AbstractBase {
	// FIXME: (string array ǤϤʤ/󥰤Υ饹Ȥ
	var $msg_;	/**< 顼åΥХåե */
	
	function AbstractBase() {
		$this->msg_=array();
	}

	/**
	@brief Ԥ
	@note 󥹥ȥ饯ǤϤʤäʳŪ˸ƤӽФ
	*/
	function init() {
	}
	
	/**
	@brief 顼֡ʥåˤäƤ뤫ɤ
	@return bool
	*/
	function isError() {
		return count($this->msg_);
	}

	/**
	@brief 顼å񤭹
	@param $msg string or array
	*/
	function setError($msg) {
		if(is_array($msg)) {
			foreach($msg as $m) {
				$this->msg_[]=$m;
			}
		}
		else {
			$this->msg_[]=$msg;
		}
	}

	/**
	@brief 顼åʸ֤
	@return array ʸ
	*/
	function getError() {
		return $this->msg_;
	}

	// FIXME: б
	/**
	@brief 顼åɽ
	@return html message
	*/
	function displayMessage() {
		if($this->isError()) {
    		$msg =& $this->getError();
    		print "<ul>";
    		foreach($msg as $s) {
    			print "<li><font color=\"red\">{$s}</font>";
    		}
    		print "</ul>";
		}
	}
}


/**
@brief Ūʥե
*/
class AbstractForm extends AbstractBase {
	/**
	@brief 
	*/
	function init(&$data) {
		if(exFrame::isPost()) {
			$this->perform($data);
			return $this->isError() ? ACTIONFORM_INIT_FAIL : ACTIONFORM_PERFORM_SUCCESS;
		}
		else {
			$this->load($data);
			return ACTIONFORM_INIT_SUCCESS;
		}
	}

	function perform($data) {}
	function load($data) {}


	/**
	@brief ϰꤷĴ٤
	@return bool
	*/
	function validateEasyNum($target,$min=null,$max=null) {
		if(!is_numeric($target))
			return false;
		
		if($min==!null && $target<$min)
			return false;

		if($max==!null && $target>$max)
			return false;

		return true;
	}

}

/**
@brief XoopsObject Ѥ뤿Υե
@memo exAbstractActionForm Υե
*/
class exAbstractForm extends AbstractForm {
	var $xoopsObj_;
	var $xoopsObjHandler_;
	var $_classname_;

	/**
	@brief 
	*/
	function init(&$obj) {
		$this->_validateClass($obj);
		if($this->isError())
			return ACTIONFORM_INIT_FAIL;

		$this->xoopsObj_=&$obj;

		if(exFrame::isPost()) {
			$this->perform();
			return $this->isError() ? ACTIONFORM_INIT_FAIL : ACTIONFORM_PERFORM_SUCCESS;
		}
		else {
			$this->load();
			return ACTIONFORM_INIT_SUCCESS;
		}
	}

	function perform(){}
	
	function load() {}

	function &getObject() {
		return $this->xoopsObj_;
	}

	/**
	@brief 饹å
	@param $obj object åоݤΥ󥹥
	@param $classname string ᥤ󥯥饹̾ʾά _classname_ лѡ 
	*/
	function _validateClass($obj,$classname=null) {
		if($classname==null)
			$classname=$this->_classname_;

		if(get_class($obj)==strtolower($classname))
			return true;

		$this->setError("ClassCheck Error");

		return false;
	}
}



	/**
	@brief Ūʥեࡣ
	*/
	class AbstractActionForm {
		function init() {
			if ($_SERVER['REQUEST_METHOD']=='POST') {
				return $this->perform();
			} else {
				return $this->load();
			}
		}
		
		function perform(){
			return ACTIONFORM_INIT_FAIL;
		}
		
		function load() {
			return ACTIONFORM_INIT_SUCCESS;
		}
	}

	/**
	@brief 顼åΥХåե AbstractActionForm γĥ
	*/
	class _ActionForm extends AbstractActionForm {
		var $isError_ =false;
		var $messages_ =array();
		
		function _setError($message=null) {
			if($message) $this->_setMessage($message);
			$this->isError_=true;
		}

		function isError() {
			return $this->isError_;
		}
		
		function _setMessage($message) {
			if (is_array($message)){
				foreach ( $message as $mes )
					$this->messages_[] = $mes;
			} else {
				$this->messages_[] = $message;
			}
		}

		// TODO isError ȤϢȤŤ
		function getMessage() {
			$this->messages_;
		}
		
		/**
		@brief åХåեѤ顼ꥹȥǽϤޤ
		@param color ʸ顼λꡣ̵ΤȤ顼ǤֻǽϤޤ
		@return string
		*/
		function displayMessage($color="auto") {
			$str="%s";
			if ( strtolower($color)=="auto" ) {
				if($this->isError()) $str='<span style="color:#ff0000;">%s</span>';
				else {
					$str="<span style=\"color:".$color.";\">%s</span>";
				}
			} else {
				$str="<span style=\"color:".$color.";\">%s</span>";
			}
			print "<ul>";
			foreach($this->messages_ as $mes ) {
				print "<li>".sprintf($str,$mes)."</li>";
			}
			print "</ul>";
		}
	}

	/**
	@brief XoopsObject Ǽ˥ cleanVars Ѥ褦ĥ줿 ActionForm
	@note Ȥƻ:եƤ XoopsObject ƤפƤȤ
	\par ץѥƥXoopsObject󥹥󥹤Ѥ뤳Ȥǡ̤ȥ˥
	\par μ֤ʤޤʣˤʤäȤ ActionForm  AbstractActionForm Ȥ٤Ǥ
	*/
	class exAbstractActionForm extends _ActionForm {
		var $obj_=null;
		var $_classname_="";
		var $_subclass_="";
		var $_obj_handler_=null;	/**< perform() ľ¸˻Ȥϥɥ */

		function init(&$obj) {
			if ($this->_classcheck($obj)) {
				if ($_SERVER['REQUEST_METHOD']=='POST') {
					$this->obj_=&$obj;
					return $this->perform();
				} else {
					$this->obj_=&$obj;
					return $this->load();
				}
			} else {
				return ACTIONFORM_INIT_FAIL;
			}
		}
		
		function _classcheck(&$obj) {
			$ret =false;
			if ($this->_classname_=="" or get_class($obj)==strtolower($this->_classname_))
				$ret =true;
				
			if(!$ret) {
				if ($this->_subclass_=="" or is_subclass_of($obj,strtolower($this->_subclass_)))
					$ret =true;
			}

			if (!$ret) {
				$this->_setError();
				$this->_setMessage("Class check Fail");
			}

			return $ret;
		}
		
		function perform() {
			return ACTIONFORM_INIT_SUCCESS;
		}

		function setClassname($classname) {
			$this->_classname_=$classname;
		}

		function setSubClassname($classname) {
			$this->_subclass_=$classname;
		}

		function getObject() {
			return $this->obj_;
		}
	}
	
	
?>