<?php
/**
@brief ŵŪʥȥ齸
*/
/*
 Copyright (c) 2003-2004, minahito
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the nor the names of its contributors may be used to 
  endorse or promote products derived from this software without specific 
  prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
*/

	define("CONTROLLER_INIT_FAIL", 0);
	define("CONTROLLER_INIT_SUCCESS", 1);
	define("CONTROLLER_SERVICE_FAIL", 0);
	define("CONTROLLER_SERVICE_SUCCESS", 1);

	class AbstractController {
		function init(){}
		function doService() { }
	}

	/**
	@brief ŵŪʥץӥ塼¸륳ȥ
	\par Υ饹ϡŵŪʥץӥ塼Υȥñ˼ΤǤ
	\par ѥŪʥץӥ塼ȥνʣɤ򸺤餹Ȥޤ
	\par Ȥ
	\par ץӥ塼ȥϡexPreviewTemplate ϥ饹뤿ˡ
	\par exPreviewTemplate ɬפ classname  ̾
	\par å󤫤饢եФΥ̾Ρ
	\par եफФ֥Ȥ¸뤿Υϥɥ̾
	\par 쥯ȤΤΣգң̤ɬפȤޤ
	\par init() ᥽åɤǤͿƲ
	\par init() ᥽åɤ CONTROLLER_INIT_SUCCESS ֤ doService() Ƥ
	\par ޤ
	@note init()᥽åɤϥ顼֤ޤ󤬡Ū˥顼֤ɤޤ
	\par ΤǡƤӽФǤɬ顼ԤäƲ
	*/
	class PreviewController extends AbstractController {
		var $class_name_;	/**< ȡȲɬפʥե९饹̾ */
		var $action_name_;	/**< ³ǧå̾Ȥ˻Ȥ̾*/
		var $redirect_url_;
		var $handler_name_;	/**< ¸˻Ѥϥɥ̾άΡ */
		var $session_name_;	/**< եब¸줿å̾ */
		var $preview_form_;	/**< PreviewTemplate Υ饹̾ */
		var $_form_;

		/**
		@param $session_name å󤫤ͤФȤѤ̾άȡƱ̾Ѥ
		*/
		function init($class_name, $action_name,$redirect_url,$handler_name,
			$session_name=null,$preview_form="exPreviewForm") {

			$this->class_name_=$class_name;
			$this->action_name_=$action_name;
			$this->handler_name_=$handler_name;
			$this->redirect_url_=$redirect_url;
			if($session_name===null)
				$this->session_name_=$action_name;
			else
				$this->session_name_=$session_name;
			$this->preview_form_=$preview_form;

			return CONTROLLER_INIT_SUCCESS;
		}
	
		function doService() {
			global $xoopsDB;
			$this->_form_=&Session::get($this->session_name_);
			if(!($this->_form_))
				exblog_fetal(__FILE__,__LINE__,"Session::get Error");

			$classname = $this->preview_form_;
			$preForm = new $classname ();
			$preForm->setClassname($this->class_name_);
			$preForm->setAction($this->action_name_);
			switch($preForm->init($this->_form_)) {
				case ACTIONFORM_INIT_FAIL:
					exblog_fetal(__FILE__,__LINE__,$preForm->getMessage()); // FIXME ǤΤ
					break;

				case ACTIONFORM_INIT_SUCCESS:
					$preTemplate = new PreviewTemplate();
					$preForm->obj_->getObject();
					if($preTemplate->init($preForm)==INPUT_TEMPLATE_INIT_SUCCESS) {
						$preTemplate->display();
					}
					else
						exblog_fetal(__FILE__,__LINE__,"PreviewTemplate has not been initialized.");
					break;

				case ACTIONFORM_PERFORM_SUCCESS:
					Session::unregister($this->session_name_);
					$objectHandler=new $this->handler_name_ ($xoopsDB);
					if ( $objectHandler->insert($this->_form_->getObject()) )
						if ($this->redirect_url_)
							redirect_header($this->redirect_url_,1,"SUCCESS");
						else
							return CONTROLLER_SERVICE_SUCCESS;
					else
						if ($this->redirect_url_)
							redirect_header($this->redirect_url_,1,"FAILED");
						else
							return CONTROLLER_SERVICE_FAIL;
			}
		}
		
		function getFormObject() {
			return $this->_form_;
		}
	}

class ListupController extends AbstractController {
	var $list_template_;
	
	function init($list_template) {
		$this->list_template_=$list_template;
		return CONTROLLER_INIT_SUCCESS;
	}
	
	function doService() {
		$dumy=null;
		$template = new $this->list_template_();
		switch ($template->init($dumy)) {
			case LIST_TEMPLATE_INIT_SUCCESS:
				$template->display();
				break;

			case LIST_TEMPLATE_INIT_FAIL:
				return CONTROLLER_SERVICE_FAIL;
		}

		return CONTROLLER_SERVICE_SUCCESS;
	}
	


}


class InputController extends AbstractController {
	var $id_;
	var $id_name_;	/** < POST ݤ ID */
	var $obj_hdlname_;	/** < ϥɥݤ̾ */
	var $edit_formname_;	/** < ǥåȥե̾ */
	var $input_template_;	/** < ץåȥƥץ졼̾ */
	var $regist_;		/** <å˥쥸ȤȤ̾ */
	var $nextpage_;	/** < Υڡ */
	var $errpage_="";

	function init ($arr) {
		global $xoopsDB;
		$this->id_name_=$arr['id_name'];
		$this->obj_hdlname_=$arr['handler'];
		$this->edit_formname_=$arr['form'];
		$this->input_template_=$arr['input'];
		$this->regist_=$arr['regist'];
		$this->nextpage_=$arr['next_page'];
		$this->obj_=null;

		$handler=new $obj_hdlname($xoopsDB);

		if(exFrame::isPost()){
			if(is_numeric($_POST[$this->id_name_])) {
				$this->id_=intval($_POST[$this->id_name_]);
				$this->obj_=&$handler->get($this->id_);
			}
		}
		else {
			if(isset($_GET['id'])) {
				if(is_numeric($_GET['id'])) {
					$this->id_=intval($_GET['id']);
					$this->obj_=&$handler->get($this->id_);
					if(!is_object($this->obj_)) {
						redirect_header($errpage,1,"DATA NO EXISTS");
						return CONTROLLER_INIT_FAIL;
					}
				}
			}
		}

		if(!is_object($this->obj_)) {
			$this->obj_=&$handler->create();
		}

		return CONTROLLER_INIT_SUCCESS;
	}

	/**
	@return array array(id,obj) / false
	*/
	function getInfomation() {
		return (array($this->id_,$this->obj_));
	}

	function doService() {
		$form=new $this->edit_formname_();

		switch($form->init($this->obj_)) {
			case ACTIONFORM_INIT_FAIL:
				print_r($this->getError());	//FIXME
				return CONTROLLER_SERVICE_FAIL;

    		case ACTIONFORM_INIT_SUCCESS:
    			break;

			case ACTIONFORM_PERFORM_SUCCESS:
				Session::register($this->regist_,$form);
				header("location:".$this->nextpage_);
				exit;
		} 
		
		$template=new $this->input_template_();

		switch($template->init($form)) {
			case INPUT_TEMPLATE_INIT_FAIL:
				$template->displayMessage();
				return CONTROLLER_SERVICE_FAIL;

			case INPUT_TEMPLATE_INIT_SUCCESS:
				$template->display();
				return CONTROLLER_SERVICE_SUCCESS;
		}
	}
}

?>
