<?php
/*
 Copyright (c) 2003-2004, minahito
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the nor the names of its contributors may be used to 
  endorse or promote products derived from this software without specific 
  prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 SUCH DAMAGE.
*/
	/**
	@brief ץӥ塼̤Ǥ⤦ POST 줿Ȥͤ򹹿ץӥ塼ե
	@note ΥեȤˤϡ󥻥μդʤФޤ
	\par ͳϡPOST ͤ򸫤ƤʤǤ⤷POST ͤ򸫤 Yes 
	\par  perform() 򥪡С饤ɤɬפޤ
	*/
	class exPreviewForm extends exAbstractActionForm {
		var $yesno_ = false;
		var $token_=null;
		var $action_name_="";
		
		function setAction($action_name) {
			$this->action_name_=trim($action_name);
		}
		
		function init(&$obj) {
			if ($this->action_name_=="") {
				$this->_setError();
				$this->_setMessage("Token name not setup");
				return ACTIONFORM_INIT_FAIL;
			}
			$this->token_ = new CSRFToken($this->action_name_);
			$ret = parent::init($obj);

			// եȤƤνֻ˥å˥ȡ
			if ($ret==ACTIONFORM_INIT_SUCCESS)
				$this->token_->setSession();

			return $ret;
		}

		/**
		// TODO ͡बʤ硢̵Ǥ褦ˤ롣⤷ϥե饰Ǥ⤤
		*/
		function perform() {
			// ȡȲ
			if (!$this->token_->inquiry($this->action_name_)) {
				$this->_setError("A token is not in agreement.");
				return ACTIONFORM_PERFORM_FAIL;
			}
			$this->yesno_=true;
			return ACTIONFORM_PERFORM_SUCCESS;
		}

		function getObject() {
			return $this->obj_;
		}
		
		function &getStructure() {
			//  Form  Obj  Form ʤΤ
			$obj = $this->obj_->getObject();
			$ret = $obj->getStructure();
			$ret['token']['name']=$this->token_->action_name_;
			$ret['token']['value']=$this->token_->value_;
			return $ret;
		}
	}
	
	class exSimplePreviewForm extends exPreviewForm {
		function &getStructure() {
			$ret = $this->obj_->getStructure();
			$ret['token']['name']=$this->token_->action_name_;
			$ret['token']['value']=$this->token_->value_;
			return $ret;
		}
	}

	class PreviewTemplate extends InputTemplate {
		function init(&$form) {
			$this->form_=&$form;
			return INPUT_TEMPLATE_INIT_SUCCESS;
		}

		function display() {
			$arr = $this->form_->getStructure();
			$form= new XoopsThemeForm("PREVIEW_CONFIRM","preview_confirm",$_SERVER['SCRIPT_NAME'] );
        	
			foreach ( $arr as $key=>$val ) {
				if ( $key=="token" ) {
					$form->addElement(new XoopsFormHidden($this->form_->action_name_,$val['value']));
				} else
					$form->addElement(new XoopsFormLabel($key,$val));
			}
        	$formtray = new XoopsFormElementTray("ACTION");
        	$formtray->addElement( new XoopsFormButton ( "", "save", "Confirm", "submit" ) );
        	$backButton = new XoopsFormButton ( "", "back", "Back", "button" );
        	$backButton->setExtra('onclick="javascript:history.go(-1);"');
        	$formtray->addElement($backButton);
        	
        	$form->addElement($formtray);
        	$form->display();
		}
	}
?>