<?php
/**
@brief ե륿
@version $Id$
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

define("BXTODO_FILTER_NOW",0);
define("BXTODO_FILTER_SCOUT",1);
define("BXTODO_FILTER_ALL",2);

class UserTodoFilter extends exAbstractFilterForm {
	var $uid_=false;
	var $mode_=false;
	var $sort_=array ("id","input_date","limit_date","priority","achievement","title");

	function fetch()
	{
		global $xoopsUser;
		if(is_object($xoopsUser)) {
			$this->uid_=$xoopsUser->uid();
		}
		$this->mode_=$this->getPositiveIntger('mode');
		if($this->mode_->BXTODO_FILTER_ALL)
			$this->mode_=BXTODO_FILTER_ALL;
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);
		$criteria->add(new Criteria('uid',$this->uid_));
		switch($this->mode_) {
			case BXTODO_FILTER_SCOUT:
				$criteria->add(new Criteria("limit_date",time(),"<"));
				break;

			case BXTODO_FILTER_NOW:
				$criteria->add(new Criteria("achievement",100,"<"));
				break;
		}

		return $criteria;
	}
	
	function getDefaultCriteria($start=0,$limit=0)
	{
		$criteria=new CriteriaCompo();
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$criteria->setSort('priority');
		return $criteria;
	}

	function getExtra()
	{
		$ret=array();
		$ret['mode']=$this->mode_;
		return $ret;
	}
}

class ToDoTableModel extends exListTableModel {
	var $_column_=array("CHK","PRIORITY","TITLE","LIMIT_DATE","ACHIEVEMENT","INPUT_DATE");
	var $filter_;

	function ToDoTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new UserTodoFilter();
	}

	function init()
	{
		$handler =& bxToDo::getHandler('todo');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$objs = $handler->getObjects($this->listController_->getCriteria());

		foreach ( $objs as $obj ) {
			$this->_row_data_[]=$obj->getArray();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtChk($arr)
	{
		return "<input type='checkbox' name='id[]' value='".$arr['id']."'>";
	}

	function getValueAtTitle($arr)
	{
		return @sprintf("<a href='submit.php?id=%u'>%s</a>",$arr['id'],$arr['title']);
	}

	function getValueAtInput_date($arr)
	{
		return formatTimestamp($arr['input_date']);
	}

	function getValueAtLimit_date($arr)
	{
		if($arr['limit_date']<time())
			return @sprintf("<font color='red'>%s</font>",formatTimestamp($arr['limit_date']));
		else
			return formatTimestamp($arr['limit_date']);
	}

	function getValueAtAchievement($arr)
	{
		if($arr['achievement']==0)
			return _MD_BXTODO_LANG_NOSTART;
		elseif($arr['achievement']==100)
			return _MD_BXTODO_LANG_FINISHED;
		else
			return $arr['achievement']."%";
	}
}

class bxToDoListTableRender extends exListTableRender {
	function _fetchHtmlHead ()
	{
		$ret=@sprintf("[<a href='index.php?mode=%u'>%s</a>]",BXTODO_FILTER_NOW,_MD_BXTODO_LANG_NOW_TODO).
			@sprintf("[<a href='index.php?mode=%u'>%s</a>]",BXTODO_FILTER_SCOUT,_MD_BXTODO_LANG_SCOUT_TODO).
			@sprintf("[<a href='index.php?mode=%u'>%s</a>]",BXTODO_FILTER_ALL,_MD_BXTODO_LANG_ALL_TODO);
		$ret.="<form action='process.php' method='post'>";
		$ret.=parent::_fetchHtmlHead();
		return $ret;
	}

	function _fetchHtmlFoot()
	{
		$ret=parent::_fetchHtmlFoot();
		$ret.="<input type='submit' name='op' value='NEW TODO'>";
		$ret.="<input type='submit' name='op' value='FINISH'>";
		$ret.="<input type='submit' name='op' value='DELETE'>";
		$ret.="</form>";
		return $ret;
	}
}

?>