<?php
/**
@version $Id: user.php,v 1.5 2004/07/26 09:04:21 minahito Exp $
*/

require_once "xoops/user.php";

class bxBBSUser extends exXoopsUserObject {
	var $cookieUser_;
	
	function getStructure($type='s')
	{
		$ret=&parent::getStructure($type);
		if(is_object($this->cookieUser_))
			$ret['cookie']=$this->cookieUser_->getArray($type);
		return $ret;
	}
}

class bxBBSCookieUser extends exXoopsObject {
	function bxBBSCookieUser($name=null,$email=null,$url=null,$passwd=null,$icon=null,$col=null) {
		$this->initVar('name', XOBJ_DTYPE_TXTBOX, null, false, 60);
		$this->initVar('email', XOBJ_DTYPE_TXTBOX, null, true, 60);
		$this->initVar('url', XOBJ_DTYPE_TXTBOX, 'http://', false, 100);
		$this->initVar('passwd', XOBJ_DTYPE_TXTBOX, null, false, 32);

		if(is_array($name))
			$this->assignVars($name);
	}
	
	/**
	@brief åؤΥå
	*/
	function setCookie($cookiename='xoops_bxbbs') {
		setcookie ( $cookiename,
				implode ( "<>",
				array ( $this->getVar('name','e'),$this->getVar('email','e'),$this->getVar('icon','e'),
					$this->getVar('col','e'),$this->getVar('passwd','e'),$this->getVar('url','e'))),
					time()+60*60*24*30 );
	}

	/**
	@brief å鼫ʬۤ
	*/
	function getCookie($cookiename='xoops_bxbbs') {
		if(isset($_COOKIE[$cookiename])) {
			$ts=&MyTextSanitizer::getInstance();
			$tmp=explode("<>",$_COOKIE[$cookiename]);

			$this->setVar('name',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[0])));
			$this->setVar('email',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[1])));
			$this->setVar('passwd',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[2])));
			$this->setVar('url',$ts->stripSlashesGPC($ts->stripSlashesGPC($tmp[3])));
		}
	}

	/**
	@brief ꥯȤ
	*/
	function fetch() {
		$this->setVar('name',$_POST['name']);
		$this->setVar('email',$_POST['email']);
		$this->setVar('passwd',$_POST['passwd']);
		$this->setVar('url',$_POST['url']);
	}
}


?>