<?php
/**
@version $Id$
*/

require_once dirname(__FILE__)."/../include/nusoap.php";
require_once "xoops/xoops.php";

class AmazonSoapHandler
{
	var $soapurl_=null;
	var $tag_=null;
	var $devtag_=null;
	var $client_=null;
	var $proxy_=null;
	
	function AmazonSoapHandler()
	{
		$config=exXoops::getModuleConfigByDirname(exXoops::getDirname(__FILE__));
		$this->soapurl_=$config['soapurl'];
		$this->tag_=$config['tag'];
		$this->devtag_=$config['devtag'];
	}

	function &getInstance()
	{
		static $handler;
		if(!is_object($handler))
			$handler=new AmazonSoapHandler();
			
		return $handler;
	}

	function get($asin)
	{
		$ret = array();

		if(!$this->client_) {
			$this->client_ = new soapclient($this->soapurl_,true);
			$this->proxy_ = $this->client_->getProxy();
		}

    	$params=array(
    		'asin'=>trim($asin),
    		'tag'=>$this->tag_,
    		'type'=>'heavy',
    		'devtag' => $this->devtag_,
    		'locale' => 'jp'
    	);

		$res = $this->proxy_->AsinSearchRequest($params);

		if(!isset($res['faultstring'])) {
			$items = $res['Details'];
			$total = count($items);

			foreach($items as $item) {
				foreach($item as $key=>$value) {
					if(!is_array($value))
						$ret[$key] = mb_convert_encoding($value,'euc-jp','auto');	// FIXME
				}
			}
		}
		
		return $ret;
	}
}

?>