<?php
/**
@version $Id$
*/

require_once dirname(__FILE__)."/../include/nusoap.php";
require_once "xoops/xoops.php";

class AmazonSoapHandler
{
	var $soapurl_=null;
	var $tag_=null;
	var $devtag_=null;
	var $client_=null;
	var $proxy_=null;
	
	var $use_multi_=false;
	var $multi_encode_=false;
	
	function AmazonSoapHandler()
	{
		$config=exXoops::getModuleConfigByDirname(exXoops::getDirname(__FILE__));
		$this->soapurl_=$config['soapurl'];
		$this->tag_=$config['tag'];
		$this->devtag_=$config['devtag'];
		$this->use_multi_=$config['use_mbstrings'];
		$this->multi_encode_=$config['mb_encoding'];
	}

	function &getInstance()
	{
		static $handler;
		if(!is_object($handler))
			$handler=new AmazonSoapHandler();
			
		return $handler;
	}

	function get($asin)
	{
		$ret = array();

		if(!$this->client_) {
			$this->client_ = new soapclient($this->soapurl_,true);
			$this->proxy_ = $this->client_->getProxy();
		}

    	$params=array(
    		'asin'=>trim($asin),
    		'tag'=>$this->tag_,
    		'type'=>'heavy',
    		'devtag' => $this->devtag_,
    		'locale' => 'jp'
    	);

		$res = $this->proxy_->AsinSearchRequest($params);

		if(!isset($res['faultstring'])) {
			$items = $res['Details'];
			$total = count($items);

			foreach($items as $item) {
				foreach($item as $key=>$value) {
					if(!is_array($value)) {
						if($this->use_multi_ && function_exists("mb_convert_encoding")) {
							$ret[$key] = mb_convert_encoding($value,$this->multi_encode_,'auto');	// FIXME
						}
						else {
							$ret[$key] = $value;	// FIXME
						}
					}
				}
			}
		}
		
		return $ret;
	}
}

?>