<?php
/**
@brief  Category ե륿
@version $Id: AdminCategoryFilter.php,v 1.2 2004/08/08 12:25:46 minahito Exp $
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";
require_once "exComponent/table/model/TypicalListTableModel.php";

class AdminCategoryTableModel extends exTypicalListTableModel {
	var $_column_=array("CID","PID","PRIORITY", "TITLE","HEADLINE","ACTION");

	function AdminCategoryTableModel($component=null)
	{
		parent::exTypicalListTableModel($component);
		$this->filter_=new AdminCategoryFilter();
		$this->handler_=&bxTips::getHandler('category');
		$this->limit_=20;
	}
	
	function getValueAtAction($arr)
	{
		$ret = @sprintf("<a href='category.php?cid=%u'>EDIT</a> | ",$arr['cid']).
			@sprintf("<a href='index.php?cid=%u'>LIST</a>",$arr['cid']);
		return $ret;
	}
}

class AdminCategoryFilter extends exAbstractFilterForm {
	var $sort_=array ("cid","pid","priority","title","headline");

	function fetch()
	{
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);
		return $criteria;
	}

	function getDefaultCriteria($start,$limit)
	{
		$criteria=parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('priority');
		return $criteria;
	}

	function getExtra()
	{
		$ret =array();
		return $ret;
	}
}

?>