<?php
/**
@brief  Tips ե륿
@version $Id: AdminTipsFilter.php,v 1.2 2004/08/08 12:25:46 minahito Exp $
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

class AdminTipsFilter extends exAbstractFilterForm {
	var $thread_=false;
	var $cid_=null;
	var $sort_=array ("id","uid","title","input_date");

	function fetch()
	{
		$this->cid_= isset($_GET['cid']) ? $_GET['cid'] : 0;
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);
		if($this->cid_)
			$criteria->add(new Criteria("cid",$this->cid_));

		return $criteria;
	}

	function getDefaultCriteria($start,$limit)
	{
		$criteria=parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('priority');
		return $criteria;
	}

	function getExtra()
	{
		$ret =array();
		return $ret;
	}
}

class AdminTipsTableModel extends exListTableModel {
	var $_column_=array("ID","CID","UID","TITLE","INPUT_DATE","ACTION");
	var $filter_;

	function AdminTipsTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new AdminTipsFilter();
	}

	function init() {
		$handler = bxTips::getHandler('tips');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$cri=$this->listController_->getCriteria();

		$objs = $handler->getObjects($this->listController_->getCriteria());
		$objs = $handler->getObjects();
		foreach ( $objs as $obj ) {
			$this->_row_data_[]=$obj->getStructure();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtInput_date($arr)
	{
		return formatTimestamp($arr['input_date']);
	}

	function getValueAtAction($arr)
	{
		$ret = @sprintf("<a href='../submit.php?id=%u'>EDIT</a>",$arr['id']);
		return $ret;
	}
}
?>