<?php

require_once "exComponent/table/ListTable.php";
require_once XOOPS_ROOT_PATH."/modules/xpToDo/admin/default/forms/TodoAdminListFilter.class.php";

define('TODOADMINLISTTABLE_PERPAGE',20);

class TodoAdminListTableComponent extends exListTableComponent
{
	function TodoAdminListTableComponent()
	{
		parent::exListTableComponent(null,null);
	}
	
	function init($filter=null)
	{
		if(!$filter)
			$filter = new TodoAdminTableModel();
		parent::init($filter);
	}
}

class TodoAdminTableModel extends exListTableModel
{
	var $_column_ = array ( "ID","UID","SUBJECT","DESCRIPTION","INPUT_DATE","TOTAL_TIME","ACTIVE" /* ,"ACTION" */ );

	function TodoAdminTableModel($component=null)
	{
		parent::exListTableModel($component);
		$this->filter_ = new ToDoAdminListFilter();
	}

	function init()
	{
		$handler=&xpToDo::getHandler('todo');
		
		$this->listController_ = new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->filter_->fetch();
		$this->listController_->fetch($handler->getCount($this->listController_->filter_->getCriteria()),TODOADMINLISTTABLE_PERPAGE);

		$objs = $handler->getObjects($this->listController_->getCriteria());
		foreach($objs as $obj) {
			$this->_row_data_[]=$obj->getStructure();
		}
		
		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	/*
	function getValueAtAction($arr)
	{
	}
	*/

	function getValueAtSubject($arr)
	{
		return @sprintf('<a href="../index.php?action=detail&amp;id=%d">%s</a>',$arr['id'],$arr['subject']);
	}

	function getValueAtInput_date($arr)
	{
		return strftime(_MD_A_XPTODO_FORMAT_DATE,$arr['input_date']);
	}

	function getValueAtTotal_time($arr)
	{
		return $arr['total_time_str'];
	}

	function getValueAtActive($arr)
	{
		return $arr['status_str'];
	}

}

?>