<?php

require_once "xoops/object.php";

class xpToDoLogObject extends exXoopsObject {
	function xpToDoLogObject($id=null)
	{
		$this->initVar('log_id', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('id', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('start_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('end_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('work_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('status', XOBJ_DTYPE_INT, 0, false);

		if ( is_array ( $id ) )
			$this->assignVars ( $id );
	}

	/**
	@brief Ȼ֤׻ޤ
	*/
	function updateWorkTime()
	{
		$this->setVar('work_time', $this->getVar('end_time') - $this->getVar('start_time') );
	}
	
	/**
	@brief Ȼ֤֤ޤ
	*/
	function getWorkTime()
	{
		$ret =array();
		$worktime = $this->getVar('work_time');
		$ret['day'] = intval($worktime / 3600);
		$ret['hour'] = intval(($worktime-$ret['day']*3600*60)/3600);
		$ret['min'] = intval(($worktime-$ret['day']*3600*60-$ret['hour']*3600)/60);
		return $ret;
	}

	function getStructure($type='s',$format="%d:%d")
	{
		$ret=parent::getStructure($type);
   		$tmp=$this->getWorkTime();
   		$ret['work_time_str']=@sprintf($format,$tmp['hour'],$tmp['min']);

		return $ret;
	}

	/// Database Connect Model
	function &getTableInfo()
	{
		$tinfo = new exTableInfomation('xptodo_log','log_id');
		return ($tinfo);
	}
}
?>