<?php

require_once "exForm/TicketForm.php";

class TodoEditForm extends exTicketActionFormEx
{
	var $id_;
	var $uid_;
	var $subject_;
	var $description_;
	var $input_date_;
	var $active_;

	function fetch(&$master) {
		parent::fetch($master);

		$this->subject_ = trim($_POST['subject']);
		if(!$this->subject_) {
			$this->addError(_MD_XPTODO_ERROR_SUBJECT_REQUIRED);
		}
		if(!$this->validateMaxLength($this->subject_, 255)) {
			$this->addError(_MD_XPTODO_ERROR_SUBJECT_SIZEOVER);
		}

		$this->active_=intval($_POST['active']);
		if(!$this->validateInRange($this->active_, 0, 1)) {
			$this->addError(_MD_XPTODO_ERROR_ACTIVE_RANGEOVER);
		}

		$this->description_ = $_POST['description'];

	}

	function load(&$master) {
		$this->id_ = $master->getVar ( 'id', 'e' );
		$this->uid_ = $master->getVar ( 'uid', 'e' );
		$this->subject_ = $master->getVar ( 'subject', 'e' );
		$this->description_ = $master->getVar ( 'description', 'e' );
		$this->input_date_ = $master->getVar ( 'input_date', 'e' );
		$this->active_ = $master->getVar ( 'active', 'e' );
	}

	function update(&$master) {
		$master->setVar ( 'subject', $this->subject_ );
		$master->setVar ( 'description', $this->description_ );
		$master->setVar ( 'active', $this->active_ );
	}
}


?>