<?php

require_once dirname(__FILE__)."/../config.inc.php";
require_once dirname(__FILE__)."/../class/command.class.php";

class MakeObject extends exToolsCommand
{
	var $mName="MakeObject";
	
	var $mOptionKeys="xg";
	var $mMinArgNum=1;

	function main()
	{
		$this->chdirXoopsModule();

		if(!file_exists("./xoops_version.php")) {
			$this->displayMessage("Common","XoopsVersionNoExists");
			exit();
		}

		$xoops_version = new XoopsVersion();

		$controller=new Controller("makeobject","default",$this);
		if(isset($this->mOptions['x'])) {
			//
			// ϤXMLեѤޤ
			//
			$controller->setAction("fromxml");
		}
		if(isset($this->mOptions['g'])) {
			//
			// XMLեŪȤưڤؤޤ
			//
			$controller->setAction("xml");
		}

		$controller->request_->setParam("xoops_version",$xoops_version);
		$controller->request_->setParam("target",$this->mArgs[0]);
		$controller->doService();
	}
	
	function needModuleName()
	{
		return true;
	}
}

$instance=new MakeObject();
$instance->main();

?>