<?php

class exToolsCommand
{
	var $mName;
	var $mMessages;
	var $mCharset="sjis";
	var $mConfig;

	var $mMinArgNum=1;

	var $mArgs=array();
	var $mOptions=array();
	var $mParamOptionKeys=null;
	var $mOptionKeys=null;

	function exToolsCommand()
	{
		global $argv;

		$this->setupConfig();
		$this->setupMessage();

		if($this->getXoopsRootPath()==null) {
			$this->displayMessage("Common","SetXoopsRootPath");
			exit(1);
		}
		
		if($this->needModuleName()) {
			if($this->getModuleName()==null) {
				$this->displayMessage("Common","SetModuleName");
				exit(1);
			}
		}

		if(count($argv)==1) {
			$this->Help();
		}
		
		//
		// ץϤޤ
		//
		$optFlag=false;
		$optionChr="";
		for($i=1;$i<count($argv);$i++) {
			if(substr($argv[$i],0,1)=='-' || substr($argv[$i],0,1)=='/') {
				$optionChr=substr($argv[$i],1,1);

				//
				// إס
				//
				if($optionChr=="h") {
					$this->Help();
				}
				//
				// ѥ᡼եץ
				//
				elseif(strpos($this->mParamOptionKeys,$optionChr)!==false) {
					$optFlag=true;
					$optKey=$optionChr;
				}
				//
				// ѥ᡼̵ץ
				//
				elseif(strpos($this->mOptionKeys,$optionChr)!==false) {
					$optFlag=false;
					$this->mOptions[$optionChr]=true;
				}
				//
				// ץ󤸤!
				//
				else {
					$this->displayMessage("Common","NoOption");
					exit();
				}
			}
			else {
				if($optFlag) {
					$this->mOptions[$optKey]=$argv[$i];
				}
				else {
					$this->mArgs[]=$argv[$i];
				}
			}
		}

		//
		// ǿӤ
		//
		if(count($this->mArgs)<$this->mMinArgNum) {
			$this->displayMessage("Common","NoArgs");
			exit();
		}
	}

	function setupConfig()
	{
		//
		// default.ini եɤ߹ˡcustom.ini ե񤭤
		//
		$this->mConfig=parse_ini_file(dirname(__FILE__)."/../default.ini",true);

		$file=dirname(__FILE__)."/../custom.ini";
		if(file_exists($file)) {
			$this->mConfig=array_merge($this->mConfig,parse_ini_file($file,true));
		}
	}

	function setupMessage()
	{
		//
		// TODO ե̵ͭΥå餤Ĥ褦
		//
		$file=$this->mConfig['extools']['message_resource'];
		$file=dirname(__FILE__)."/../resource/${file}.ini";
		$this->mMessage=parse_ini_file($file,true);
	}

	function Help()
	{
		print "\n";
		$this->displayMessage($this->mName,"Help");
		print "\n";
		print "\n";
		print "USAGE : ";
			$this->displayMessage($this->mName,"Usage");
		print "\n";
		print "\n";
		$this->displayMessage($this->mName,"Options");
		print "\n";

		exit(1);
	}

	function displayMessage()
	{
		if(func_num_args()==2) {
			$section=func_get_arg(0);
			$key=func_get_arg(1);
		}
		else {
			$section=$this->mName;
			$key=func_get_arg(0);
		}
		
		if(isset($this->mMessage[$section][$key])) {
			$string=$this->mMessage[$section][$key];
		}
		else {
			return;
		}

		//
		// Ѵ
		//
		$string=str_replace("\\n","\n",$string);
		$string=str_replace("\\t","\t",$string);
		
		$charset=$this->mConfig['extools']['display_charcode'];

		if(function_exists("mb_convert_encoding"))
			print mb_convert_encoding($string,$this->mCharset,"euc");
		else
			print $string;
	}

	function needModuleName()
	{
		return false;
	}
	
	function getModuleName()
	{
		return $_ENV['MODULE_NAME'];
	}
	
	function getXoopsRootPath()
	{
		if(isset($_ENV['XOOPS_ROOT_PATH'])) {
			return $_ENV['XOOPS_ROOT_PATH'];
		}
		elseif(isset($this->mOption['extools']['XOOPS_ROOT_PATH'])) {
			return $this->mOption['extools']['XOOPS_ROOT_PATH'];
		}

		return null;
	}
	
	function chdirXoopsModule()
	{
		chdir($this->getXoopsRootPath()."/modules/".$this->getModuleName());
	}
}

?>