<?php
/**
@file
@brief ʰץȥե
@author minahito
@version $Id$
*/

define ("EXTOOLS_ROOT_PATH",dirname(__FILE__)."/../");

class Controller
{
	var $module_;
	var $action_;
	
	var $request_;
	
	var $mCommand;
	
	function Controller($module,$action,$command=null)
	{
		$this->module_=$module;
		$this->setAction($action);
		$this->request_ = new Request();
		
		$this->mCommand=&$command;
	}

	function setAction($action)
	{
		$this->action_ = $action;
	}

	/**
	@brief ¹
	*/
	function doService()
	{
		$action_file = EXTOOLS_ROOT_PATH."/modules/".$this->module_."/actions/".$this->action_.".class.php";
		if(!file_exists($action_file))
			die("Action is Not Exists.");
		require_once $action_file;
		
		$classname = $this->module_."_".ucfirst($this->action_)."Action";

		$action_instance = new $classname;
		$action_instance->execute($this->request_,$this);
	}
}

/**
@brief Ū˰ܹԤ(?)ȥ
@remark Υȥϥ⥸塼ŪȤƤޤ
*/
class ModuleController extends Controller
{
	var	$xoops_module_name_="";		///< X2ǤΥ⥸塼̾󥹥ȥ饯ǽ
	var	$err_messages_ = array();	///< 顼åХåեǤʸ
	var	$params_;	///< ѥ᡼饹Υ󥹥

	/**
	@brief Ķѿ MODULE_NAME Ȱʤ硢顼Хåե˥顼å򥻥åȤޤ
	@todo 顼åΥå
	*/
	function ModuleController($module,$action)
	{
		$this->xoops_module_name_ = $_ENV['MODULE_NAME'];
		$this->params_ = new ParameterCollector();
		parent::Controller($module,$action);
	}
	
	/**
	@brief Υȥ餬ӥоݤȤƤ Xoops Υ⥸塼̾
	@return string
	*/
	function getXoopsModuleName()
	{
		return $this->xoops_module_name_;
	}
	
	/**
	@brief ȥΥ顼åХåե˥顼ɲäޤ
	*/
	function addErrorMessage($message)
	{
		if(is_array($message)) {
			foreach($message as $str)
				$this->err_messages_[]= $str;
		}
		else
			$this->err_messages_[]= $message;
	}
	
	/**
	@brief 顼åХåե˥顼ϿƤ뤫ɤĴ٤ޤ
	@return bool
	*/
	function isError()
	{
		return count($this->err_messages_) ? true : false;
	}

	/**
	@brief 顼褦ǤХӥϼ¹Ԥޤ
	*/
	function doService()
	{
		if($this->isError()) {
			$this->displayError();
   			die;
		}
		else {
			$this->getParameter();
			// Ǥ⤦٥顼å
    		if($this->isError()) {
    			$this->displayError();
    			die;
    		}
		}
		
		$this->_execute();
	}
	
	/**
	@brief ɤ߹߼¹Ԥ
	*/
	function _execute()
	{
		$action_file = EXTOOLS_ROOT_PATH."/modules/".$this->module_."/actions/".$this->action_.".class.php";
		if(!file_exists($action_file))
			die("Action is Not Exists.");
		require_once $action_file;
		
		$classname = $this->module_."_".ucfirst($this->action_)."Action";

		$action_instance = new $classname;
		$action_instance->execute($this,$this->params_,$this->request_);
	}
	
	/**
	@brief ѥ᡼μ
	*/
	function getParameter()
	{
		// եΥ
		$option_file = EXTOOLS_ROOT_PATH."/modules/".$this->module_."/option.php";
		if(!file_exists($option_file)) {
			$this->addErrorMessage("Option file is not exist");
			return;
		}
		require_once $option_file;

		$classname = $this->module_."_Option";

		$option_instance = new $classname;
		$this->params_->fetch($option_instance,$this);
		$this->params_->validate($option_instance,$this);
	}
	
	function displayError()
	{
		foreach($this->err_messages_ as $str)
			print $str."\n";
	}
}

class Request
{
	var $params_;
	var $attribute_;
	
	function Request()
	{
		$this->params_=array();
		$this->attribute_=array();
	}
	
	function setParam($key,$value)
	{
		$this->params_[$key]=$value;
	}

	function setParamByRef($key,&$value)
	{
		$this->params_[$key]=&$value;
	}
	
	function &getParam($key)
	{
		$ret=null;
		if(isset($this->params_[$key]))
			return $this->params_[$key];
		else
			return $ret;
	}
}

class ParameterCollector
{
	var $options_ =array();
	var $parameters_ =array();
	var $sources_ =array();
	
	/**
	@brief ץˤ碌ơѥ᡼
	*/
	function fetch(&$option,&$controller)
	{
		global $argv;
		for($i=1;$i<count($argv);$i++) {
			// ץ󤫡
			if(substr($argv[$i],0,1)=='-' || substr($argv[$i],0,1)=='/') {
				$flag = substr($argv[$i],1,1);
				// ѥ᡼դץ󤫡
				if($option->isParameter($flag)) {
					if(isset($argv[$i+1])) {	// ΥȤ¸ߤʤ
						$this->addParameter($flag,$argv[$i+1]);
						$i++;
					}
					else {	// ʤʤ饨顼
						$controller->addErrorMessage($option->getHelp());
						return;
					}
				}
				elseif($option->isOption($flag)) {	// ѥ᡼ʤץ󤫡
					$this->addOption($flag);
				}
				else {
					$controller->addErrorMessage($option->getHelp());
					return;
				}
			}
			else {	// 㤦ʤ饽Ѥ
				$this->addSource($argv[$i]);
			}
		}
	}
	
	function validate(&$option,&$controller)
	{
		if(count($this->sources_)<$option->getSourceAmmo()) {
			// FIXME::
			$controller->addErrorMessage($option->getHelp());
		}
	}
	
	function addSource($value)
	{
		$this->sources_[] = new SourceParameter($value);
	}

	function addParameter($option_name,$value)
	{
		$this->parameters_[] = new Parameter($option_name,$value);
	}
	
	function addOption($option_name)
	{
		$this->options_[] = new OptionParameter($option_name);
	}
	
	function isOption($option_name)
	{
		foreach($this->options_ as $param)
			if($param->key_==$option_name)
				return true;

		return false;
	}
}

class AbstractParameter
{
	var $key_="";
	var $value_="";
	
	function AbstractParam()
	{
	}
}

class SourceParameter
{
	function SourceParameter($value)
	{
		$this->value_ = $value;
	}
}

class Parameter
{
	function Parameter($key,$value)
	{
		$this->key_ = $key;
		$this->value_ = $value;
	}
}

class OptionParameter
{
	function OptionParameter($key)
	{
		$this->key_ = $key;
	}
}


?>