<?php
/**
@file
@brief Ȥꤢʥǡ١饹ե
@author minahito
@version $Id$
*/

	require_once "DB.php";

	class DatabaseFactory
	{
		var $user_="";
		var $pass_="";
		var $host_="";
		var $database_="";

		function DatabaseFactory($user,$pass,$host,$database="")
		{
			$this->user_=$user;
			$this->pass_=$pass;
			$this->host_=$host;
			$this->database_=$database;
		}

		function &getInstance($type)
		{
			$classname = ucfirst(strtolower($type))."Factory";
			if(!class_exists($classname)) {
				die ( "Database Error" );
			}
			
			$db = new $classname($this->user_,$this->pass_,$this->host_,$this->database_);
			return $db->getInstance();
		}
	}
	
	class MysqlFactory extends DatabaseFactory
	{
		function &getInstance()
		{
			$dsn = "mysql://".$this->user_.":".$this->pass_."@".$this->host_;
			if($this->database_)
				$dsn .= "/".$this->database_;

			$db =& DB::connect($dsn);
			if(DB::isError($db)) {
				die ( "Connect Error" );
			}

			$db->setFetchMode(DB_FETCHMODE_ASSOC);			
			
			return $db;
		}
	}

	$_mysql_type_ = array (
		"int"=>"XOBJ_DTYPE_INT",
		"varchar"=>"XOBJ_DTYPE_TXTBOX",
		"text"=>"XOBJ_DTYPE_TXTAREA"
	);

	class MysqlStructure
	{
		var $db_;
		var $table_;
		
		var $keys_;
		var $primary_keys_;
		
		var $fields_;
		
		var $tab_ = "\t\t";	///< @todo

		function MysqlStructure($db,$table)
		{
			$this->db_=&$db;
			$this->table_ = strtolower($table);

			$this->keys_ = array();
			$this->primary_keys_ = array();

			$this->fields_=array();
		}
		
		function parse()
		{
			$sql = "SHOW KEYS FROM "._DBPREFIX($this->table_);
			$res=$this->db_->Query($sql);
			
			while($row=$res->fetchRow()) {
				$this->keys_[] = $row;
				if($row['Key_name'] == 'PRIMARY') {
					$this->primary_keys_[] = $row['Column_name'];
				}
			}
			$res->free();

			// Field
			$sql ='SHOW FULL FIELDS FROM '._DBPREFIX($this->table_);
			$res=$this->db_->Query($sql);

			while($row=$res->fetchRow()) {
				$this->fields_[]=$row;
				unset($row);
			}
			$res->free();
		}
		
		function fetchStructure()
		{
			$ret = array();
			foreach ( $this->fields_ as $field ) {
				$ret[] = $field;
			}
			return $ret;
		}
		
		function fetchSQL()
		{
			$ret[] = "CREATE TABLE ".$this->table_." ( ";
			foreach ( $this->fields_ as $field ) {
				$ret[] = "\t".$field['Field']." ".$field['Type']." ".$field['Extra'].",";
			}
			$ret[] = "\tPRIMARY KEY (".implode(",",$this->primary_keys_).")";
			$ret[] = ") TYPE=MyISAM;";

			return implode("\n",$ret);
		}

		function fetchInitVar()
		{
			global $_mysql_type_;
			$ret = array();
			foreach($this->fields_ as $field) {
				$name = $field['Field'];
				$type="";
				foreach($_mysql_type_ as $key=>$val) {
					if(strstr($field['Type'],$key)!==false) {
						$type=$val;
						break;
					}
				}

				$size=0;
				if(preg_match("/\((\d+)\)/",$field['Type'],$match))
					$size=$match[1];
				
				$required = in_array($name,$this->primary_keys_) ? "true" : "false";
				
				switch($type) {
					case 'XOBJ_DTYPE_INT':
						$ret[]=$this->tab_."\$this->initVar('$name', $type, 0, $required);";
						break;

					case 'XOBJ_DTYPE_TXTBOX':
						$ret[]=$this->tab_."\$this->initVar('$name', $type, null, $required, $size);";
						break;

					case 'XOBJ_DTYPE_TXTAREA':
						$ret[]=$this->tab_."\$this->initVar('$name', $type, null, $required, null);";
						break;
				}
			}

			return implode("\n",$ret);
		}
		
		function convertXoopsObjectType($type)
		{
			$type = strtolower($type);
			if(preg_match("/^(\w+)/",$type,$match)) {
				if(strpos($type,"int")!==false) {
					return "XOBJ_DTYPE_INT";
				}
				if(strpos($type,"text")!==false) {
					return "XOBJ_DTYPE_TXTAREA";
				}
				if(strpos($type,"char")!==false) {
					return "XOBJ_DTYPE_TXTBOX";
				}
				
				return "XOBJ_DTYPE_INT";
			}
			
			return "ERROR";
		}
		
		function fetchSizeFromField($type)
		{
			if(preg_match("/\((\d+)\)$/",$type,$match)) {
				return intval($match[1]);
			}
			
			return null;
		}


		function fetchGetTableInfo()
		{
			$table = $this->table_;
			$pkey=array();
			if(count($this->primary_keys_)>1) {
				$keys=array();
				foreach ( $this->primary_keys_ as $str ) {
					$keys[] = "'".$str."'";
				}
				$pley = "array(".implode(',',$keys).")";
			}
			else {
				$pkey = "'".$this->primary_keys_[0]."'";
			}

			return "\$tinfo = new exTableInfomation('$table',$pkey);";
		}
	}


?>