<?php
/**
@file
@brief å갷饹ե
@author minahito
@version $Id$
*/

class MessageCatalogFactory
{
	function &getInstance($type)
	{
		$instance=null;
		switch(strtolower($type)){
			case 'modinfo':
				$instance = new MessageCatalogModuleInfo();
				break;

			case 'main':
				$instance = new MessageCatalogMain();
				break;

			case 'admin':
				$instance = new MessageCatalogAdmin();
				break;

			case 'block':
				$instance = new MessageCatalogBlock();
				break;
		}

		return $instance;
	}
}

/**
@biref åμ갷
*/
class MessageCatalog
{
	var $langs_;

	function MessageCatalog()
	{
		$this->langs_ = array ( 'english', 'japanese' );
	}

	function getModulePrefix()
	{
		return strtoupper($_ENV['MODULE_NAME']);
	}
	
	function getPrefix()
	{
		return "";
	}

	function getFilename()
	{
		return "";
	}

	/**
	@brief
	@param $property ץѥƥ̾
	@param $type 
	@param $name ̾
	*/
	function addTerm($property,$type,$name)
	{
		$defname = $this->getPrefix()."_".strtoupper($type)."_".strtoupper($name);

		// õ
		foreach($this->langs_ as $lang) {
			$filepath = _MODULEPATH()."/language/".$lang."/".$this->getFilename();

			$line=array();
			$fp = fopen($filepath,"rb");

    		while($str=fgets($fp,4096)) {
    			if(preg_match("!// <--- ".strtoupper($property)." PROPERTY --->!",$str)) {
    				$line[]=$str;

					// Ԥõ
					while($str=fgets($fp,4096)) {
						if(!preg_match("/\w+/",$str)) {
							if($lang=='english')
								$line[] = "define ( '$defname','".strtoupper(str_replace("_"," ",$name))."' );\n\n";
							else
								$line[] = "define ( '$defname','' );\n\n";
							break;
						}
						$line[] = $str;
					}
    			}
    			else
    				$line[]=$str;
    		}
    		fclose($fp);

    		$fp = fopen($filepath,"wb");
    		foreach($line as $str) {
    			fwrite($fp,$str);
    		}
    		fclose($fp);
		}
	}
}

class MessageCatalogModuleInfo extends MessageCatalog
{
	function getFilename()
	{
		return "modinfo.php";
	}

	function getPrefix()
	{
		return "_MI_".$this->getModulePrefix();
	}
}

class MessageCatalogMain extends MessageCatalog
{
	function getFilename()
	{
		return "main.php";
	}

	function getPrefix()
	{
		return "_MD_".$this->getModulePrefix();
	}
}

class MessageCatalogAdmin extends MessageCatalog
{
	function getFilename()
	{
		return "admin.php";
	}

	function getPrefix()
	{
		return "_MD_A_".$this->getModulePrefix();
	}
}

class MessageCatalogBlock extends MessageCatalog
{
	function getFilename()
	{
		return "block.php";
	}

	function getPrefix()
	{
		return "_MB_".$this->getModulePrefix();
	}
}

?>