/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/*
 * NX}\[X𐶐DynamicDrawpvOC
 *   ExportSrc.dll
 *
 *   ClassInfo	:NX̕ێA\[Xւ̕ϊsNX
 *
 * Copyright (c) 2002 matsumo. All rights reserved.
 *
 * @(#) $Id: ClassInfo.cpp,v 1.6 2002/07/04 10:49:34 matsumo Exp $
 *
 */

#include "stdafx.h"
#include "MpgUtil.h"
#include "ClassInfo.h"

/////////////////////////////////////////////////////////////////////////////////
//OĂ΂郁\bh

/*****************************************************************************/
/* NXevfɕĊi[											 */
/*  ENTRY : const wstring &str	:NX܂ޕ						 */
/*  RETURN: BOOL			:TRUE=										 */
/*****************************************************************************/
BOOL ClassInfo::setName(const wstring &str)
{
	wstring txt, txt2 = str, p;
	trim(txt2);
	txt = divString(txt2, L'\n');
	if(txt[0] == L'<'){
		name.stereo_type = txt;		//XeI^Cv
		txt = divString(txt2, L'\n');
	}
	p = divString(txt, L':');
	if(!txt.empty()){
		package = p;				//pbP[W
		name.name = txt.substr(1);	//NX
	}else{
		name.name = p;				//NX
	}
	if(txt2[0] == L'{'){
		name.tagged_value = txt2;	//
	}

	return(TRUE);
}

/*****************************************************************************/
/* evfɕĊi[												 */
/*  ENTRY : FCRichTextExp* pRT	:FCRichTextExp|C^				 */
/*  RETURN: BOOL			:TRUE=										 */
/*****************************************************************************/
BOOL ClassInfo::setAttribute(FCRichTextExp* pRT)
{
	wstring txt, txt2;
	vector<int> vattr;
	int i=0;

	pRT->GetText(txt2);
	trim(txt2);
	GetAttr(pRT, vattr);

	while((txt = divString(txt2, L'\n'), !txt.empty())){
		Attribute attr(txt, vattr[i++]);
		attribute.push_back(attr);
	}

	return(TRUE);
}

/*****************************************************************************/
/* \bhevfɕĊi[											 */
/*  ENTRY : FCRichTextExp* pRT	:\bhFCRichTextExp|C^			 */
/*  RETURN: BOOL			:TRUE=										 */
/*****************************************************************************/
BOOL ClassInfo::setOperation(FCRichTextExp* pRT)
{
	wstring txt, txt2;
	vector<int> vattr;
	int i=0;

	pRT->GetText(txt2);
	trim(txt2);
	GetAttr(pRT, vattr);

	while((txt = divString(txt2, L'\n'), !txt.empty())){
		Operation opr(txt, vattr[i++]);
		operation.push_back(opr);
	}

	return(TRUE);
}

/*****************************************************************************/
/* Abstract\bh邩ǂ`FbN								 */
/*  ENTRY : 				:												 */
/*  RETURN: int				:Abstract\bȟ							 */
/*****************************************************************************/
int ClassInfo::checkAbstract()
{
	//Abstract̃\bh1ł邩`FbN
	int c = 0;
	for(int i=0; i<operation.size(); i++){
		if(operation[i].bAbstract) c++;
	}
	return(c);
}

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/* source̒gt@Cɏ											 */
/*  ENTRY :	const wstring &filename:tpX̃t@C					 */
/*  RETURN: ES_Err::code	:G[R[h									 */
/*****************************************************************************/
ES_Err::code ClassInfo::write(const wstring &filename)
{
	DWORD len;
	HANDLE hFile;

	//t@Cɏo
	if((hFile=::CreateFile(WStrToTStr(filename.c_str()), GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
					 FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE){
		return(ES_Err::OPEN_FAILED);
	}
	for(int i=0; i<source.size(); i++){
		string s = WStrToTStr(LF2CRLF(source[i]).c_str());
		::WriteFile(hFile, s.c_str(), s.length(), &len, NULL);
	}
	::CloseHandle(hFile);
	return(ES_Err::SUCCESS);
}

/*****************************************************************************/
/* evfɕāAeϐɐݒ										 */
/*  ENTRY : wstring &str	:܂ޕ								 */
/*			int attr		:CI_ATTR_STATIC									 */
/*  RETURN:					:												 */
/*****************************************************************************/
ClassInfo::Attribute::Attribute(wstring &str, int attr)
{
	//)+hoge:int=5
	visibility		= ClassInfo::getVisibility(str);	//F(+)
	name			= ClassInfo::divString(str, L':');	//ϐ(hoge)
	type			= ClassInfo::divString(str, L'=');	//^(int)
	default_value	= str;								//l(5)

	bStatic			= (attr & CI_ATTR_STATIC) ? TRUE : FALSE;
}

/*****************************************************************************/
/* \bhevfɕāAeϐɐݒ									 */
/*  ENTRY : wstring &str	:\bh܂ޕ							 */
/*			int attr		:CI_ATTR_STATIC, CI_ATTR_ABSTRACT				 */
/*  RETURN:					:												 */
/*****************************************************************************/
ClassInfo::Operation::Operation(wstring &str, int attr)
{
	//)+getHoge(int a, int b):int = 6
	visibility		= ClassInfo::getVisibility(str);	//F(+)
	name			= ClassInfo::divString(str, L'(');	//\bh(getHoge)
	wstring p		= ClassInfo::divString(str, L')');	//(int a, int b)
	wstring txt;
	while((txt = divString(p, L','), !txt.empty())){	//e𕪉
		Param prm(txt);
		param.push_back(prm);
	}
	return_type		= ClassInfo::divString(str, L'=');
	return_type.erase(0, 1);							//߂l(int)
	default_value	= str;								//l(6)

	bStatic			= (attr & CI_ATTR_STATIC) ? TRUE : FALSE;
	bAbstract		= (attr & CI_ATTR_ABSTRACT) ? TRUE : FALSE;
}

/*****************************************************************************/
/* \bḧevfɕāAeϐɐݒ							 */
/*  ENTRY : wstring &str	:\bḧ܂ޕ						 */
/*  RETURN:					:												 */
/*****************************************************************************/
ClassInfo::Param::Param(wstring &str)
{
	//)int a = 6
	name			= ClassInfo::divString(str, L':');	//ϐ(a)
	type			= ClassInfo::divString(str, L'=');	//^(int)
	default_value	= str;								//l(6)
}

/////////////////////////////////////////////////////////////////////////////////
//[eBeB\bh

/*****************************************************************************/
/* 񂩂token̑O܂łԂĎc(token)strɊi[			 */
/*  ENTRY : wstring &str	:								 */
/*			wchar_t token	:token										 */
/*  RETURN: wstring			:token̑O܂ł̕							 */
/*****************************************************************************/
wstring ClassInfo::divString(wstring &str, wchar_t token)
{
	wstring ret;
	wstring::size_type pos = str.find(token);
	if(pos == -1){
		ret = str;
		str = L"";
		return ret;
	}
	ret = trim(str.substr(0, pos));		//tokenO
	str = trim(str.substr(pos+1));		//token(݂͂Ă邩?)
	return ret;
}

/*****************************************************************************/
/* visibilityԂĎc̕strɊi[							 */
/*  ENTRY : wstring &str	:											 */
/*  RETURN: wstring			:visibility(+,#,-)								 */
/*							 (visibility܂܂Ȃꍇ͋󕶎Ԃ)		 */
/*****************************************************************************/
wstring ClassInfo::getVisibility(wstring &str)
{
	wstring ret(L"");
	switch(str[0]){
	case L'+':
	case L'#':
	case L'-':
		ret = str[0];
		str.erase(0, 1);
	}
	return ret;
}

/*****************************************************************************/
/* ̍ẼXy[Xg										 */
/*  ENTRY : wstring &str	:											 */
/*  RETURN: wstring &		:g̕								 */
/*****************************************************************************/
wstring &ClassInfo::trim(wstring &str)
{
	//擪̕svȃXy[X폜
	while(str[0] == L' '){
		str.erase(0, 1);
	}

	//̕svȃXy[X폜
	while(str[str.size()-1] == L' '){
		str.erase(str.size()-1, 1);
	}

	return(str);
}

/*****************************************************************************/
/* LF(0x0a)CR+LF(0x0d,0x0a)ϊ											 */
/*  ENTRY : wstring &str	:											 */
/*  RETURN: wstring &		:ϊ̕									 */
/*****************************************************************************/
wstring &ClassInfo::LF2CRLF(wstring &str)
{
	wstring::size_type pos = 0;
	while((pos = str.find(L'\n', pos)) >= 0){
		str.replace(pos, 1, L"\r\n");
		if(pos >= str.size()-2){
			break;
		}else{
			pos += 2;
		}
	}

	return(str);
}

/*****************************************************************************/
/* FCRichTextExpsPʂ̕𒊏ovectorɊi[					 */
/* (ݑΉĂ鑮́AΑ̂Ɖ̂)									 */
/*  ENTRY : FCRichTextExp* pRT	:FCRichTextExp̃|C^					 */
/*			vector<int>& vattr	:oʂ̊i[							 */
/*  RETURN: none			:												 */
/*****************************************************************************/
void ClassInfo::GetAttr(FCRichTextExp* pRT, vector<int>& vattr)
{
	real	mmX;
	real	mmBaseLine;
	long	lLine;
	long	lChar;
	short	nAfterSpace = short(MINSHORT);
	const	FCStatChar* pChar;
	const	FCSFontRec*	pFontRec = NULL;

	int a = 0;
	pChar = pRT->CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine);
	while(pChar != NULL){
		switch(pChar->m_wChar){
		//
		case FDRCH_LINES_AND_CROSSSTAT:
			a |= (pChar->m_byUnderline ? CI_ATTR_STATIC : 0);
			break;
		//Α
		case FDRCH_FONT_AND_OFFSET:
			a |= (FMpgGetMolipMain()->GetEnv()->GetSFontRec(pChar->m_foidFont)->m_byItalic) ? CI_ATTR_ABSTRACT : 0;
			break;
		//s
		case FDRCH_RETURN:
			vattr.push_back(a);
			a = 0;
			break;
		}
		pChar = pRT->CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine);
	}
}
