/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/*
 * NX}\[X𐶐DynamicDrawpvOC
 *   ExportSrc.dll
 *
 *   ExtractDlg    :j[Ă΂ĊeݒƒǒĂяosNX
 *
 * Copyright (c) 2002 matsumo. All rights reserved.
 *
 * @(#) $Id: ExtractDlg.cpp,v 1.2 2002/07/04 10:49:34 matsumo Exp $
 *
 */

#include "stdafx.h"
#include <tchar.h>		// For _TCHAR.
#include "Module.h"		// For FMpgGetModule().
#include "MpgUtil.h"
#include "resource.h"
#include "error.h"
#include "ExtractDlg.h"
#include "ExtractInfo_Java.h"
#include "ExtractInfo_Csharp.h"
#include "ExtractInfo_CPP.h"
//ToDo:o͌ǉƂ͂[#include "ExtractInfo_`.h"]ǉ܂

extern const wchar_t*	s_wcpComponentName;

ExtractDlg::Property ExtractDlg::prop;
const wchar_t* ExtractDlg::langname[] = {
	ExtractInfo_Java::LangName,
	ExtractInfo_Csharp::LangName,
	ExtractInfo_CPP::LangName,
	//ToDo:o͌ǉƂ͂[ExtractInfo_`::LangName,]ǉ܂
	NULL
};

/////////////////////////////////////////////////////////////////////////////////
//OĂ΂郁\bh

/*****************************************************************************/
/* \[Xo͂̃j[IɌĂ΂										 */
/* tH_IɂׂẴV[gAimF								 */
/*  ENTRY : 				:												 */
/*  RETURN: BOOL			:TRUE=, FALSE=s							 */
/*****************************************************************************/
BOOL ExtractDlg::show()
{
	ES_Err::code cd;
	int r = DialogBox((HINSTANCE)FMpgGetModule()->GetModuleHandle(), MAKEINTRESOURCE(IDD_SETTING), FMpgGetMolipMain()->GetMainWindow(), (DLGPROC)SettingDlgProc);
	if(r == IDOK){
		if(prop.lang == 0){
			ExtractInfo_Java ei;
			cd = ei.exec(prop.path);
		}else if(prop.lang == 1){
			ExtractInfo_Csharp ei;
			cd = ei.exec(prop.path);
		}else if(prop.lang == 2){
			ExtractInfo_CPP ei;
			cd = ei.exec(prop.path);
		//ToDo:o͌ǉƂ͂[}else if()`]ǉ܂
		}

		//sʂ\
		if(cd == ES_Err::SUCCESS){
			//
			::MessageBoxW(FMpgGetMolipMain()->GetMainWindow(), ES_Err::getMsg(cd), s_wcpComponentName, MB_OK | MB_ICONINFORMATION | MB_TOPMOST);
		}else{
			//G[
			::MessageBoxW(FMpgGetMolipMain()->GetMainWindow(), ES_Err::getMsg(cd), L"G[", MB_OK | MB_ICONERROR | MB_TOPMOST);
		}
	}
	return(TRUE);
}

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/* tH_I_CAO\ătH_I						 */
/*  ENTRY : wstring &path	:ItpX+t@Ci[Q		 */
/*							 (ʒu\tH_Ă)				 */
/*  RETURN: BOOL			:TRUE=, FALSE=s							 */
/*****************************************************************************/
BOOL ExtractDlg::GetPath(wstring &path)
{
	//IMallocC^[tFCXւ̃|C^擾
	LPMALLOC pMalloc;
	if(::SHGetMalloc(&pMalloc ) != NOERROR){
		return (FALSE);
	}

	BROWSEINFOW bsi;
	wchar_t f[MAX_PATH];
	LPITEMIDLIST pIDLr;
	::ZeroMemory(&bsi, sizeof(BROWSEINFO));

	LPITEMIDLIST pIDLd;
	LPSHELLFOLDER pDesktopFolder; 

	if( ::SHGetDesktopFolder( &pDesktopFolder ) != NOERROR ){
		return(FALSE);
	}

	OLECHAR ochPath[MAX_PATH];
	ULONG   chEaten;		//̃TCY
	ULONG   dwAttributes;	//
	HRESULT hRes;

	wcsncpy(ochPath, path.c_str(), MAX_PATH-1);
	ochPath[MAX_PATH-1] = 0;

	//ۂITEMIDLIST擾
	hRes = pDesktopFolder->ParseDisplayName( NULL, NULL, ochPath, &chEaten, &pIDLd, &dwAttributes);
	if(hRes != NOERROR){
		pIDLd = NULL;
	}
	pDesktopFolder->Release();

	bsi.hwndOwner = FMpgGetMolipMain()->GetMainWindow();
	bsi.pidlRoot = NULL;
	bsi.pszDisplayName = f;
	bsi.lpszTitle = L"Java\[Xo͂tH_...";
	bsi.ulFlags = BIF_RETURNONLYFSDIRS;
	bsi.lpfn = (BFFCALLBACK)BrowseCallbackProc;
	bsi.lParam = (LPARAM)pIDLd;
//	bsi.iImage
	BOOL ret = FALSE;
	if((pIDLr = ::SHBrowseForFolderW(&bsi))){
		// PIDL t@CVXẽpXɕϊ 
		if(::SHGetPathFromIDListW(pIDLr, f)){
			path = f;
			path += L"\\";
			ret = TRUE;
		}
	}

	//[X
	if(pIDLd != NULL){
		pMalloc->Free(pIDLd);
	}
	if(pIDLr != NULL){
		pMalloc->Free(pIDLr);
	}
	pMalloc->Release();

	return(ret);
}

/*****************************************************************************/
/* SHBrowseForFolder()̃R[obN										 */
/*  ENTRY : HWND hWnd		:												 */
/*			UINT uMsg		:												 */
/*			LPARAM lParam	:												 */
/*			LPARAM lpData	:												 */
/*  RETURN: int				:												 */
/*****************************************************************************/
int AFXAPI ExtractDlg::BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	//ɃtH_I
	if(uMsg == BFFM_INITIALIZED){
		::SetWindowText(hWnd, _T("ExportSrc o͐̑I"));
		::SendMessage(hWnd, BFFM_SETSELECTION, FALSE, lpData);
	}else{
		TCHAR chText[MAX_PATH];
		if(::SHGetPathFromIDList((LPITEMIDLIST)lParam, chText)){
			::SendMessage(hWnd, BFFM_SETSTATUSTEXT, TRUE, (LPARAM)chText);
		}
	}

	return(0);
}

/*****************************************************************************/
/* ݒ_CAOpEBhEvV[W									 */
/*  ENTRY : HWND hDlgWnd	:												 */
/*			UINT msg		:												 */
/*			WPARAM wParam	:												 */
/*			LPARAM lParam	:												 */
/*  RETURN: LRESULT			:												 */
/*****************************************************************************/
LRESULT CALLBACK ExtractDlg::SettingDlgProc(HWND hDlgWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	TCHAR t[MAX_PATH];
	wstring path;

	switch(msg){
	case WM_INITDIALOG:
		SetDialogData(hDlgWnd);
		return(TRUE);
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
			//property荞
			GetDlgItemText(hDlgWnd, IDC_DEST, t, MAX_PATH);
			prop.path = TStrToWStr(t);	//**Ō\\t
			prop.all = SendDlgItemMessage(hDlgWnd, IDC_TARGET_ALL, BM_GETCHECK, 0, 0) == BST_CHECKED;
			prop.lang = (int)SendDlgItemMessage(hDlgWnd, IDC_LANG, CB_GETCURSEL, 0, 0);
		case IDCANCEL:
			EndDialog(hDlgWnd, LOWORD(wParam));
			return(TRUE);
		case IDC_BROWSE:
			GetDlgItemText(hDlgWnd, IDC_DEST, t, MAX_PATH);
			path = TStrToWStr(t);
			if(GetPath(path)){
				//IꂽtH_𔽉f
				SetDlgItemText(hDlgWnd, IDC_DEST,  WStrToTStr(path.c_str()));
			}
			break;
		}
		break;
	}
	return(FALSE);
}

/*****************************************************************************/
/* PropertyNX̃o[̒lݒ_CAOɔf					 */
/*  ENTRY : HWND hWnd		:												 */
/*  RETURN: none			:												 */
/*****************************************************************************/
void ExtractDlg::SetDialogData(HWND hWnd)
{
	//o͐
	const CString &pFilePath = FMpgGetMolipMain()->GetDocument()->GetPathName();
	CString fn = pFilePath.Left(pFilePath.ReverseFind('\\')+1);
	SetDlgItemText(hWnd, IDC_DEST,  fn);

	//o͌
	string lang;
	HWND hTmp = GetDlgItem(hWnd, IDC_LANG);
	for(int i=0; langname[i] != NULL; i++){
		lang = WStrToTStr(langname[i]);
		SendMessage(hTmp, CB_ADDSTRING, 0, (LPARAM)lang.c_str());
	}
	SendMessage(hTmp, CB_SETCURSEL, prop.lang, 0);	//I

	//o͑Ώ
	if(prop.all){
		SendDlgItemMessage(hWnd, IDC_TARGET_ALL, BM_SETCHECK, BST_CHECKED, 0);
	}else{
		SendDlgItemMessage(hWnd, IDC_TARGET_SELECTED, BM_SETCHECK, BST_CHECKED, 0);
	}
	EnableWindow(GetDlgItem(hWnd, IDC_STATIC_TARGET), FALSE);	//**Ƃ肠
	EnableWindow(GetDlgItem(hWnd, IDC_TARGET_ALL), FALSE);		//**Ƃ肠
	EnableWindow(GetDlgItem(hWnd, IDC_TARGET_SELECTED), FALSE);	//**Ƃ肠
}
