/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/*
 * NX}\[X𐶐DynamicDrawpvOC
 *   ExportSrc.dll
 *
 *   ExtractInfo_Csharp :NX}ClassInfo֕Kvȏ̒osNX
 *                       ɂˑ̂镔(C#p)
 *
 * Copyright (c) 2002 matsumo. All rights reserved.
 *
 * @(#) $Id: ExtractInfo_Csharp.cpp,v 1.6 2002/07/03 10:30:12 matsumo Exp $
 */

#include "stdafx.h"
#include "ExtractInfo_Csharp.h"

/////////////////////////////////////////////////////////////////////////////////
//̃NẌɊւ

//gq
wchar_t* ExtractInfo_Csharp::FileExt = L".cs";
//ꖼ
wchar_t* ExtractInfo_Csharp::LangName = L"C#";

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/* visibility(+,#,-)ɑΉ(public,protected,private)Ԃ			 */
/*  ENTRY : wstring &str	:visibility܂ޕ							 */
/*  RETURN: wstring			:											 */
/*****************************************************************************/
wstring ExtractInfo_Csharp::getVisibilityName(const wstring &str)
{
	switch(str[0]){
	case L'+':
		return L"public";
	case L'#':
		return L"protected";
	case L'-':
		return L"private";
	case L'%':					//**Ƃ肠
		return L"internal";
	default:
		return L"";
	}
}

/*****************************************************************************/
/* name, attribute, operation\[X𐶐sourceɊi[			 */
/*  ENTRY : ClassInfo &ci	:NX̃NXւ̎Q						 */
/*  RETURN: BOOL			:TRUE=, FALSE=s							 */
/*****************************************************************************/
BOOL ExtractInfo_Csharp::makeSource(ClassInfo &ci)
{
#define COMMENT L"//"
#define INDENT  L"\t"

	wstring t;
	int i;
	BOOL bInterface = FALSE;
	if(ci.name.stereo_type.find(L"interface") != -1){
		bInterface = TRUE;
	}

	//\[Xwb_
	for(i=0; i<ci.header.size(); i++){
		t  = COMMENT;
		t += ci.header[i];
		t += L"\n";
		ci.source.push_back(t);
	}

	//NameSpace
	t = L"\n";
	if(ci.package.empty()){
		t += COMMENT L"namespace `";
	}else{
		t += L"namespace ";
		t += ci.package;
	}
	t += L"{\n\n";
	ci.source.push_back(t);

	//̑
	t = COMMENT L"using System.`;\n\n";
	ci.source.push_back(t);

	//NX
	t = L"";
	if(ci.name.tagged_value.find(L"abstract") != -1 || ci.checkAbstract()){
		t += L"abstract ";
	}
	if(ci.name.tagged_value.find(L"sealed") != -1){
		t += L"sealed ";
	}
	if(bInterface){
		t += L"interface ";
	}else{
		t += L"class ";
	}
	t += ci.name.name;
	if(ci.generalization.size()){	//p
		t += L" : ";
		t += ci.generalization[0];
	}
	if(ci.realization.size()){		//C^[tF[X
		if(ci.generalization.size() == 0){
			t += L" : ";
		}else{
			t += L", ";
		}
		for(i=0; i<ci.realization.size(); i++){
			t += ci.realization[i];
			if(i<ci.realization.size()-1) t += L", ";
		}
	}
	t += L" {\n";
	ci.source.push_back(t);

	//
	if(!bInterface){	//C^[tF[X͑
		t  = INDENT COMMENT L"property\n";
		ci.source.push_back(t);
		for(i=0; i<ci.attribute.size(); i++){
			t  = INDENT;
			//rWreB
			if(!ci.attribute[i].visibility.empty()){
				t += getVisibilityName(ci.attribute[i].visibility);
				t += L" ";
			}
			//static
			if(ci.attribute[i].bStatic){
				t += L"static ";
			}
			//^
			if(!ci.attribute[i].type.empty()){
				t += ci.attribute[i].type;
				t += L" ";
			}
			//
			t += ci.attribute[i].name;
			t += L";\n";
			ci.source.push_back(t);
		}
		t = L"\n";
		ci.source.push_back(t);
	}

	//\bh
	t  = INDENT COMMENT L"method\n";
	ci.source.push_back(t);
	for(i=0; i<ci.operation.size(); i++){
		wstring w = getVisibilityName(ci.operation[i].visibility);

		t  = INDENT;
		if(!bInterface){
			//rWreB(C^[tF[X͎gpłȂ)
			if(!w.empty()){
				t += w;
				t += L" ";
			}
			//abstract
			if(ci.operation[i].bAbstract){
				t += L"abstract ";
			}
		}
		//static
		if(ci.operation[i].bStatic){
			t += L"static ";
		}
		//Al
		if(ci.operation[i].return_type.empty()){
			t += L"void";
		}else{
			t += ci.operation[i].return_type;
		}
		t += L" ";
		//\bh
		t += ci.operation[i].name;
		//
		t += L"(";
		for(int j=0; j<ci.operation[i].param.size(); j++){
			t += ci.operation[i].param[j].type;
			t += L" ";
			t += ci.operation[i].param[j].name;
			//̃ftHg
			if(!ci.operation[i].param[j].default_value.empty()){
				t += L" =";
				t += ci.operation[i].param[j].default_value;
			}
			if(j<ci.operation[i].param.size()-1) t += L", ";
		}
		t += L")";
		//Al̃ftHg
		if(!ci.operation[i].default_value.empty()) t += L" =";
		t += ci.operation[i].default_value;

		if(bInterface || ci.operation[i].bAbstract){
			//C^[tF[XAAbstractĂꍇ͒`̂
			t += L";\n";
		}else{
			//\bh̎
			t += L"\n";
			t += INDENT L"{\n";
			t += INDENT INDENT COMMENT L"\n";
			if(!ci.operation[i].return_type.empty()){
				t += INDENT INDENT L"return <value>;\n";
			}
			t += INDENT L"}\n";
			if(i<ci.operation.size()-1) t += L"\n";
		}
		ci.source.push_back(t);
	}

	//NX tb^[
	t = L"}\n";
	ci.source.push_back(t);

	//NameSpace
	t = L"\n";
	if(ci.package.empty()){
		t+= COMMENT;
	}
	t+= L"} //namespace\n";
	ci.source.push_back(t);

	return(TRUE);
}
