// $Id: customize.js 29 2010-11-09 00:55:23Z mashiki $
// ユーザ別設定画面表示
function(){
	if (Xji.winCustomize) {
		Xji.winCustomize.show();
		return;
	}
	var st = new Ext.data.JsonStore({
		// store configs
		autoDestroy: true,
		autoLoad: true,
		url: P.UrlWiki + '?cmd=extwiki&mode=getConfig',
		// reader configs
		root: 'data',
		idProperty: 'name',
		fields: ['name', 'type', 'value', {name:'siteDefault',mapping:'value'}, 'title', 'comment','reg','min','max','customizable'],
		listeners: {load: function(s,r,o){
			editors = [];
			s.each(function(r){
				if (P[r.data.name]) r.set('value', P[r.data.name]);
				var e;
				switch(r.get('type')) {
				case 'int':
					e = new XG.GridEditor(new XF.NumberField({
						allowBlank: false,
						maxValue: r.get('max'),
						minValue: r.get('min'),
						selectOnFocus: true,
						style:'text-align:left;'
					}));
					break
				case 'bool':
					e =  new XG.GridEditor(
						new XF.Field({
							autoCreate: {tag: 'select', children: [
								{tag: 'option', value:'true', html: 'True'},
								{tag: 'option', value:'false', html: 'False'}
							]},
							getValue: function(){return this.el.dom.value=='true'}
						}),
						{autoSize: 'both'}
					);
					break;
				case 'string':
					var reg = r.get('reg');
					if (reg.match(/^[-\|_a-zA-Z0-9]+$/)) {
						var opts = reg.split('|')
						for (var i=0,opt;opt=opts[i];++i) {
							opts[i] = {tag: 'option', value:opt, html: opt};
						}
						e = new XG.GridEditor(
							new XF.Field({
								autoCreate: {tag: 'select', children: opts}
							}),
							{autoSize: 'both'}
						);
					} else {
						e = new XG.GridEditor(new XF.TextField({
							selectOnFocus: true,
							regex: new RegExp('^'+reg+'$')
						}));
					}
					break;
				}
				r.set('editor', e);
			});
			this.commitChanges();
			this.filterBy(function(r,i){return r.get('customizable')});
		}}
	});

	var rndr = function(tag) {
		return function(v, m, r) {
			return r.get('customizable')?'<'+tag+'>'+v+'</'+tag+'>':v
		}
	}
	Xji.winCustomize = new Ext.Window({
		minHeight: 200,
		minWidth: 400,
		height: 300,
		width: 600,
		maxPct: 70,
		modal: true,
		title: 'ユーザ別セッティング項目',
		closable:true,
		closeAction:'hide',
		layout: 'fit',
		items: {
			xtype: 'editorgrid',
			store: st,
			viewConfig: {forceFit:true},
			enableColumnMove: false,
			enableHdMenu: false,
			stripeRows: true,
			trackMouseOver: false,
			sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
			clicksToEdit: 1,
			cm: new XG.ColumnModel({
				getCellEditor: function(ci,ri) {
					var row = st.getAt(ri);
					return row.data.editor;
				},
				isCellEditable: function(col, row) {
					return this.columns[col].dataIndex=='value' && st.getAt(row).get('customizable');
				},
				columns: [
					{ sortable:true, header:'設定項目', dataIndex :'title', width: 105},
					{ sortable:true, header:'name',  dataIndex :'name',  width: 55, align:'right', renderer:rndr('b')},
					{ sortable:true, header:'値', dataIndex:'value', width:70,
								editable:true, renderer:rndr('u')},
					{ sortable:true, header:'デフォルト', dataIndex :'siteDefault', width: 70},
					{ sortable:true, header:'備考', dataIndex :'comment', width: 120}
				]
			})
		},
		tbar: [{
			text: 'Save',
			handler: function(b, e){
				var cc={};
				st.each(function(r){
					var d = r.data;
					if (d.value!=d.siteDefault) cc[d.name] = d.value;
				});
				cc = Ext.util.JSON.encode(cc);
				XC.set('custom_conf', cc, (new Date).add(Date.DAY, 45));
				XM.alert(
					'ユーザ設定の保存',
					'ユーザ設定の保存が完了しました。<br />'+
					'設定を反映するには[Ctrl]+[f5]でリロードしてください。',
					function(b, t){ Xji.winCustomize.hide(); }
				);
			}
		},'-',{
			text: 'Reset',
			handler: function(b, e){
				st.each(function(r){
					r.set('value', r.data.siteDefault);
				});
			}
		},'-',{
			text: 'Display',
			menu:[{
				text: 'All',
				handler: function(b, e){
					st.filterBy(function(r,i){return true});
				}
			},'-',{
				text: 'Editable',
				handler: function(b, e){
					st.filterBy(function(r,i){return r.get('customizable')});
				}
			}]
		},'-',{
			text: 'Cancel',
			handler: function(b, e){
				Xji.winCustomize.hide();
			}
		}]
	});
	Xji.winCustomize.show();
}
